<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NumTripsType StructType
 * Meta information extracted from the WSDL
 * - documentation: This element allows a user to specify the number of itineraries returned.
 * @subpackage Structs
 */
class NumTripsType extends AbstractStructBase
{
    /**
     * The Number
     * Meta information extracted from the WSDL
     * - base: xs:short
     * - default: 9
     * - minInclusive: 1
     * - use: optional
     * @var int
     */
    public $Number;
    /**
     * The PerDateMin
     * Meta information extracted from the WSDL
     * - documentation: Minimum number of options to be retrieved for each combination of outbound/inbound dates.
     * - use: optional
     * @var int
     */
    public $PerDateMin;
    /**
     * The PerDateMax
     * Meta information extracted from the WSDL
     * - documentation: Maximum number of options to be retrieved for each combination of outbound/inbound dates.
     * - use: optional
     * @var int
     */
    public $PerDateMax;
    /**
     * The PerMarket
     * Meta information extracted from the WSDL
     * - documentation: Number of itineraries per market for alternate cities request. It allows to control market diversity only.
     * - use: optional
     * @var int
     */
    public $PerMarket;
    /**
     * Constructor method for NumTripsType
     * @uses NumTripsType::setNumber()
     * @uses NumTripsType::setPerDateMin()
     * @uses NumTripsType::setPerDateMax()
     * @uses NumTripsType::setPerMarket()
     * @param int $number
     * @param int $perDateMin
     * @param int $perDateMax
     * @param int $perMarket
     */
    public function __construct($number = 9, $perDateMin = null, $perDateMax = null, $perMarket = null)
    {
        $this
            ->setNumber($number)
            ->setPerDateMin($perDateMin)
            ->setPerDateMax($perDateMax)
            ->setPerMarket($perMarket);
    }
    /**
     * Get Number value
     * @return int|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param int $number
     * @return \SabreSoap\StructType\NumTripsType
     */
    public function setNumber($number = 9)
    {
        $this->Number = $number;
        return $this;
    }
    /**
     * Get PerDateMin value
     * @return int|null
     */
    public function getPerDateMin()
    {
        return $this->PerDateMin;
    }
    /**
     * Set PerDateMin value
     * @param int $perDateMin
     * @return \SabreSoap\StructType\NumTripsType
     */
    public function setPerDateMin($perDateMin = null)
    {
        $this->PerDateMin = $perDateMin;
        return $this;
    }
    /**
     * Get PerDateMax value
     * @return int|null
     */
    public function getPerDateMax()
    {
        return $this->PerDateMax;
    }
    /**
     * Set PerDateMax value
     * @param int $perDateMax
     * @return \SabreSoap\StructType\NumTripsType
     */
    public function setPerDateMax($perDateMax = null)
    {
        $this->PerDateMax = $perDateMax;
        return $this;
    }
    /**
     * Get PerMarket value
     * @return int|null
     */
    public function getPerMarket()
    {
        return $this->PerMarket;
    }
    /**
     * Set PerMarket value
     * @param int $perMarket
     * @return \SabreSoap\StructType\NumTripsType
     */
    public function setPerMarket($perMarket = null)
    {
        $this->PerMarket = $perMarket;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SabreSoap\StructType\NumTripsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
