<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MessageData StructType
 * @subpackage Structs
 */
class MessageData extends AbstractStructBase
{
    /**
     * The MessageId
     * Meta information extracted from the WSDL
     * - base: string
     * - minLength: 1
     * - ref: tns:MessageId
     * @var string
     */
    public $MessageId;
    /**
     * The Timestamp
     * Meta information extracted from the WSDL
     * - ref: tns:Timestamp
     * @var string
     */
    public $Timestamp;
    /**
     * The RefToMessageId
     * Meta information extracted from the WSDL
     * - base: string
     * - minLength: 1
     * - minOccurs: 0
     * - ref: tns:RefToMessageId
     * @var string
     */
    public $RefToMessageId;
    /**
     * The TimeToLive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:TimeToLive
     * @var string
     */
    public $TimeToLive;
    /**
     * The Timeout
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:Timeout
     * @var int
     */
    public $Timeout;
    /**
     * Constructor method for MessageData
     * @uses MessageData::setMessageId()
     * @uses MessageData::setTimestamp()
     * @uses MessageData::setRefToMessageId()
     * @uses MessageData::setTimeToLive()
     * @uses MessageData::setTimeout()
     * @param string $messageId
     * @param string $timestamp
     * @param string $refToMessageId
     * @param string $timeToLive
     * @param int $timeout
     */
    public function __construct($messageId = null, $timestamp = null, $refToMessageId = null, $timeToLive = null, $timeout = null)
    {
        $this
            ->setMessageId($messageId)
            ->setTimestamp($timestamp)
            ->setRefToMessageId($refToMessageId)
            ->setTimeToLive($timeToLive)
            ->setTimeout($timeout);
    }
    /**
     * Get MessageId value
     * @return string|null
     */
    public function getMessageId()
    {
        return $this->MessageId;
    }
    /**
     * Set MessageId value
     * @param string $messageId
     * @return \SabreSoap\StructType\MessageData
     */
    public function setMessageId($messageId = null)
    {
        $this->MessageId = $messageId;
        return $this;
    }
    /**
     * Get Timestamp value
     * @return string|null
     */
    public function getTimestamp()
    {
        return $this->Timestamp;
    }
    /**
     * Set Timestamp value
     * @param string $timestamp
     * @return \SabreSoap\StructType\MessageData
     */
    public function setTimestamp($timestamp = null)
    {
        $this->Timestamp = $timestamp;
        return $this;
    }
    /**
     * Get RefToMessageId value
     * @return string|null
     */
    public function getRefToMessageId()
    {
        return $this->RefToMessageId;
    }
    /**
     * Set RefToMessageId value
     * @param string $refToMessageId
     * @return \SabreSoap\StructType\MessageData
     */
    public function setRefToMessageId($refToMessageId = null)
    {
        $this->RefToMessageId = $refToMessageId;
        return $this;
    }
    /**
     * Get TimeToLive value
     * @return string|null
     */
    public function getTimeToLive()
    {
        return $this->TimeToLive;
    }
    /**
     * Set TimeToLive value
     * @param string $timeToLive
     * @return \SabreSoap\StructType\MessageData
     */
    public function setTimeToLive($timeToLive = null)
    {
        $this->TimeToLive = $timeToLive;
        return $this;
    }
    /**
     * Get Timeout value
     * @return int|null
     */
    public function getTimeout()
    {
        return $this->Timeout;
    }
    /**
     * Set Timeout value
     * @param int $timeout
     * @return \SabreSoap\StructType\MessageData
     */
    public function setTimeout($timeout = null)
    {
        $this->Timeout = $timeout;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SabreSoap\StructType\MessageData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
