<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LegTaxes StructType
 * @subpackage Structs
 */
class LegTaxes extends AbstractStructBase
{
    /**
     * The Tax
     * Meta information extracted from the WSDL
     * - documentation: Any individual tax applied to the fare
     * - maxOccurs: 99
     * @var \SabreSoap\StructType\AirTaxType[]
     */
    public $Tax;
    /**
     * The Number
     * Meta information extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $Number;
    /**
     * Constructor method for LegTaxes
     * @uses LegTaxes::setTax()
     * @uses LegTaxes::setNumber()
     * @param \SabreSoap\StructType\AirTaxType[] $tax
     * @param int $number
     */
    public function __construct(array $tax = array(), $number = null)
    {
        $this
            ->setTax($tax)
            ->setNumber($number);
    }
    /**
     * Get Tax value
     * @return \SabreSoap\StructType\AirTaxType[]|null
     */
    public function getTax()
    {
        return $this->Tax;
    }
    /**
     * Set Tax value
     * @param \SabreSoap\StructType\AirTaxType[] $tax
     * @return \SabreSoap\StructType\LegTaxes
     */
    public function setTax(array $tax = array())
    {
        $this->Tax = $tax;
        return $this;
    }
    /**
     * Add item to Tax value
     * @throws \InvalidArgumentException
     * @param \SabreSoap\StructType\AirTaxType $item
     * @return \SabreSoap\StructType\LegTaxes
     */
    public function addToTax(\SabreSoap\StructType\AirTaxType $item)
    {
        $this->Tax[] = $item;
        return $this;
    }
    /**
     * Get Number value
     * @return int|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param int $number
     * @return \SabreSoap\StructType\LegTaxes
     */
    public function setNumber($number = null)
    {
        $this->Number = $number;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SabreSoap\StructType\LegTaxes
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
