<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FlightSegment StructType
 * Meta information extracted from the WSDL
 * - documentation: A container for necessary data to describe one or more flight segments.
 * @subpackage Structs
 */
class FlightSegment extends AbstractStructBase
{
    /**
     * The DepartureDateTime
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $DepartureDateTime;
    /**
     * The DepartureAirport
     * Meta information extracted from the WSDL
     * - documentation: Departure point of flight segment.
     * @var \SabreSoap\StructType\ResponseLocationType
     */
    public $DepartureAirport;
    /**
     * The ArrivalAirport
     * Meta information extracted from the WSDL
     * - documentation: Arrival point of flight segment.
     * @var \SabreSoap\StructType\ResponseLocationType
     */
    public $ArrivalAirport;
    /**
     * The DepartureAirportCode
     * @var string
     */
    public $DepartureAirportCode;
    /**
     * The ArrivalAirportCode
     * @var string
     */
    public $ArrivalAirportCode;
    /**
     * Constructor method for FlightSegment
     * @uses FlightSegment::setDepartureDateTime()
     * @uses FlightSegment::setDepartureAirport()
     * @uses FlightSegment::setArrivalAirport()
     * @uses FlightSegment::setDepartureAirportCode()
     * @uses FlightSegment::setArrivalAirportCode()
     * @param string $departureDateTime
     * @param \SabreSoap\StructType\ResponseLocationType $departureAirport
     * @param \SabreSoap\StructType\ResponseLocationType $arrivalAirport
     * @param string $departureAirportCode
     * @param string $arrivalAirportCode
     */
    public function __construct($departureDateTime = null, \SabreSoap\StructType\ResponseLocationType $departureAirport = null, \SabreSoap\StructType\ResponseLocationType $arrivalAirport = null, $departureAirportCode = null, $arrivalAirportCode = null)
    {
        $this
            ->setDepartureDateTime($departureDateTime)
            ->setDepartureAirport($departureAirport)
            ->setArrivalAirport($arrivalAirport)
            ->setDepartureAirportCode($departureAirportCode)
            ->setArrivalAirportCode($arrivalAirportCode);
    }
    /**
     * Get DepartureDateTime value
     * @return string
     */
    public function getDepartureDateTime()
    {
        return $this->DepartureDateTime;
    }
    /**
     * Set DepartureDateTime value
     * @param string $departureDateTime
     * @return \SabreSoap\StructType\FlightSegment
     */
    public function setDepartureDateTime($departureDateTime = null)
    {
        $this->DepartureDateTime = $departureDateTime;
        return $this;
    }
    /**
     * Get DepartureAirport value
     * @return \SabreSoap\StructType\ResponseLocationType|null
     */
    public function getDepartureAirport()
    {
        return $this->DepartureAirport;
    }
    /**
     * Set DepartureAirport value
     * @param \SabreSoap\StructType\ResponseLocationType $departureAirport
     * @return \SabreSoap\StructType\FlightSegment
     */
    public function setDepartureAirport(\SabreSoap\StructType\ResponseLocationType $departureAirport = null)
    {
        $this->DepartureAirport = $departureAirport;
        return $this;
    }
    /**
     * Get ArrivalAirport value
     * @return \SabreSoap\StructType\ResponseLocationType|null
     */
    public function getArrivalAirport()
    {
        return $this->ArrivalAirport;
    }
    /**
     * Set ArrivalAirport value
     * @param \SabreSoap\StructType\ResponseLocationType $arrivalAirport
     * @return \SabreSoap\StructType\FlightSegment
     */
    public function setArrivalAirport(\SabreSoap\StructType\ResponseLocationType $arrivalAirport = null)
    {
        $this->ArrivalAirport = $arrivalAirport;
        return $this;
    }
    /**
     * Get DepartureAirportCode value
     * @return string|null
     */
    public function getDepartureAirportCode()
    {
        return $this->DepartureAirportCode;
    }
    /**
     * Set DepartureAirportCode value
     * @param string $departureAirportCode
     * @return \SabreSoap\StructType\FlightSegment
     */
    public function setDepartureAirportCode($departureAirportCode = null)
    {
        $this->DepartureAirportCode = $departureAirportCode;
        return $this;
    }
    /**
     * Get ArrivalAirportCode value
     * @return string|null
     */
    public function getArrivalAirportCode()
    {
        return $this->ArrivalAirportCode;
    }
    /**
     * Set ArrivalAirportCode value
     * @param string $arrivalAirportCode
     * @return \SabreSoap\StructType\FlightSegment
     */
    public function setArrivalAirportCode($arrivalAirportCode = null)
    {
        $this->ArrivalAirportCode = $arrivalAirportCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SabreSoap\StructType\FlightSegment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
