<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Fees StructType
 * Meta information extracted from the WSDL
 * - documentation: This is a collection of Fees
 * @subpackage Structs
 */
class Fees extends AbstractStructBase
{
    /**
     * The Fee
     * Meta information extracted from the WSDL
     * - documentation: Any additional fee incurred by the passenger but not shown on the ticket.
     * - maxOccurs: 9
     * @var \SabreSoap\StructType\AirFeeType[]
     */
    public $Fee;
    /**
     * Constructor method for Fees
     * @uses Fees::setFee()
     * @param \SabreSoap\StructType\AirFeeType[] $fee
     */
    public function __construct(array $fee = array())
    {
        $this
            ->setFee($fee);
    }
    /**
     * Get Fee value
     * @return \SabreSoap\StructType\AirFeeType[]|null
     */
    public function getFee()
    {
        return $this->Fee;
    }
    /**
     * Set Fee value
     * @param \SabreSoap\StructType\AirFeeType[] $fee
     * @return \SabreSoap\StructType\Fees
     */
    public function setFee(array $fee = array())
    {
        $this->Fee = $fee;
        return $this;
    }
    /**
     * Add item to Fee value
     * @throws \InvalidArgumentException
     * @param \SabreSoap\StructType\AirFeeType $item
     * @return \SabreSoap\StructType\Fees
     */
    public function addToFee(\SabreSoap\StructType\AirFeeType $item)
    {
        $this->Fee[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SabreSoap\StructType\Fees
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
