<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareInfoType StructType
 * Meta information extracted from the WSDL
 * - documentation: Rules for this priced option.
 * @subpackage Structs
 */
class FareInfoType extends AbstractStructBase
{
    /**
     * The DepartureDate
     * Meta information extracted from the WSDL
     * - documentation: Departure Date for this priced fare.
     * - minOccurs: 0
     * @var string
     */
    public $DepartureDate;
    /**
     * The FareReference
     * Meta information extracted from the WSDL
     * - documentation: FareReferenceCode can be used for either the Fare Basis Code or the Fare Class Code. | Used for Character Strings, length 1 to 8
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * @var string
     */
    public $FareReference;
    /**
     * The RuleInfo
     * Meta information extracted from the WSDL
     * - documentation: Information regarding restrictions governing use of the fare.
     * @var \SabreSoap\StructType\RuleInfoType
     */
    public $RuleInfo;
    /**
     * The MarketingAirline
     * Meta information extracted from the WSDL
     * - documentation: The marketing airline.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \SabreSoap\StructType\CompanyNameType[]
     */
    public $MarketingAirline;
    /**
     * The DepartureAirport
     * Meta information extracted from the WSDL
     * - documentation: Departure point of flight segment.
     * @var \SabreSoap\StructType\ResponseLocationType
     */
    public $DepartureAirport;
    /**
     * The ArrivalAirport
     * Meta information extracted from the WSDL
     * - documentation: Arrival point of flight segment.
     * @var \SabreSoap\StructType\ResponseLocationType
     */
    public $ArrivalAirport;
    /**
     * The NegotiatedFare
     * Meta information extracted from the WSDL
     * - documentation: Indicator to show if this is a private fare.
     * - default: false
     * - type: xs:boolean
     * - use: optional
     * @var bool
     */
    public $NegotiatedFare;
    /**
     * The NegotiatedFareCode
     * Meta information extracted from the WSDL
     * - documentation: Code used to identify the private fare.
     * - type: xs:string
     * - use: optional
     * @var string
     */
    public $NegotiatedFareCode;
    /**
     * Constructor method for FareInfoType
     * @uses FareInfoType::setDepartureDate()
     * @uses FareInfoType::setFareReference()
     * @uses FareInfoType::setRuleInfo()
     * @uses FareInfoType::setMarketingAirline()
     * @uses FareInfoType::setDepartureAirport()
     * @uses FareInfoType::setArrivalAirport()
     * @uses FareInfoType::setNegotiatedFare()
     * @uses FareInfoType::setNegotiatedFareCode()
     * @param string $departureDate
     * @param string $fareReference
     * @param \SabreSoap\StructType\RuleInfoType $ruleInfo
     * @param \SabreSoap\StructType\CompanyNameType[] $marketingAirline
     * @param \SabreSoap\StructType\ResponseLocationType $departureAirport
     * @param \SabreSoap\StructType\ResponseLocationType $arrivalAirport
     * @param bool $negotiatedFare
     * @param string $negotiatedFareCode
     */
    public function __construct($departureDate = null, $fareReference = null, \SabreSoap\StructType\RuleInfoType $ruleInfo = null, array $marketingAirline = array(), \SabreSoap\StructType\ResponseLocationType $departureAirport = null, \SabreSoap\StructType\ResponseLocationType $arrivalAirport = null, $negotiatedFare = false, $negotiatedFareCode = null)
    {
        $this
            ->setDepartureDate($departureDate)
            ->setFareReference($fareReference)
            ->setRuleInfo($ruleInfo)
            ->setMarketingAirline($marketingAirline)
            ->setDepartureAirport($departureAirport)
            ->setArrivalAirport($arrivalAirport)
            ->setNegotiatedFare($negotiatedFare)
            ->setNegotiatedFareCode($negotiatedFareCode);
    }
    /**
     * Get DepartureDate value
     * @return string|null
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * Set DepartureDate value
     * @param string $departureDate
     * @return \SabreSoap\StructType\FareInfoType
     */
    public function setDepartureDate($departureDate = null)
    {
        $this->DepartureDate = $departureDate;
        return $this;
    }
    /**
     * Get FareReference value
     * @return string|null
     */
    public function getFareReference()
    {
        return $this->FareReference;
    }
    /**
     * Set FareReference value
     * @param string $fareReference
     * @return \SabreSoap\StructType\FareInfoType
     */
    public function setFareReference($fareReference = null)
    {
        $this->FareReference = $fareReference;
        return $this;
    }
    /**
     * Get RuleInfo value
     * @return \SabreSoap\StructType\RuleInfoType|null
     */
    public function getRuleInfo()
    {
        return $this->RuleInfo;
    }
    /**
     * Set RuleInfo value
     * @param \SabreSoap\StructType\RuleInfoType $ruleInfo
     * @return \SabreSoap\StructType\FareInfoType
     */
    public function setRuleInfo(\SabreSoap\StructType\RuleInfoType $ruleInfo = null)
    {
        $this->RuleInfo = $ruleInfo;
        return $this;
    }
    /**
     * Get MarketingAirline value
     * @return \SabreSoap\StructType\CompanyNameType[]|null
     */
    public function getMarketingAirline()
    {
        return $this->MarketingAirline;
    }
    /**
     * Set MarketingAirline value
     * @param \SabreSoap\StructType\CompanyNameType[] $marketingAirline
     * @return \SabreSoap\StructType\FareInfoType
     */
    public function setMarketingAirline(array $marketingAirline = array())
    {
        $this->MarketingAirline = $marketingAirline;
        return $this;
    }
    /**
     * Add item to MarketingAirline value
     * @throws \InvalidArgumentException
     * @param \SabreSoap\StructType\CompanyNameType $item
     * @return \SabreSoap\StructType\FareInfoType
     */
    public function addToMarketingAirline(\SabreSoap\StructType\CompanyNameType $item)
    {
        $this->MarketingAirline[] = $item;
        return $this;
    }
    /**
     * Get DepartureAirport value
     * @return \SabreSoap\StructType\ResponseLocationType|null
     */
    public function getDepartureAirport()
    {
        return $this->DepartureAirport;
    }
    /**
     * Set DepartureAirport value
     * @param \SabreSoap\StructType\ResponseLocationType $departureAirport
     * @return \SabreSoap\StructType\FareInfoType
     */
    public function setDepartureAirport(\SabreSoap\StructType\ResponseLocationType $departureAirport = null)
    {
        $this->DepartureAirport = $departureAirport;
        return $this;
    }
    /**
     * Get ArrivalAirport value
     * @return \SabreSoap\StructType\ResponseLocationType|null
     */
    public function getArrivalAirport()
    {
        return $this->ArrivalAirport;
    }
    /**
     * Set ArrivalAirport value
     * @param \SabreSoap\StructType\ResponseLocationType $arrivalAirport
     * @return \SabreSoap\StructType\FareInfoType
     */
    public function setArrivalAirport(\SabreSoap\StructType\ResponseLocationType $arrivalAirport = null)
    {
        $this->ArrivalAirport = $arrivalAirport;
        return $this;
    }
    /**
     * Get NegotiatedFare value
     * @return bool|null
     */
    public function getNegotiatedFare()
    {
        return $this->NegotiatedFare;
    }
    /**
     * Set NegotiatedFare value
     * @param bool $negotiatedFare
     * @return \SabreSoap\StructType\FareInfoType
     */
    public function setNegotiatedFare($negotiatedFare = false)
    {
        $this->NegotiatedFare = $negotiatedFare;
        return $this;
    }
    /**
     * Get NegotiatedFareCode value
     * @return string|null
     */
    public function getNegotiatedFareCode()
    {
        return $this->NegotiatedFareCode;
    }
    /**
     * Set NegotiatedFareCode value
     * @param string $negotiatedFareCode
     * @return \SabreSoap\StructType\FareInfoType
     */
    public function setNegotiatedFareCode($negotiatedFareCode = null)
    {
        $this->NegotiatedFareCode = $negotiatedFareCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SabreSoap\StructType\FareInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
