<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareDetailsType StructType
 * Meta information extracted from the WSDL
 * - documentation: You don't need to specify all of these attributes for a given flight. For some of them it is sufficient to be specified in the last flight of a given fare component. For details, see notes below --- the attributes are annotated with
 * ,,last Flight in Fare Component''.
 * @subpackage Structs
 */
class FareDetailsType extends AbstractStructBase
{
    /**
     * The ComponentNo
     * Meta information extracted from the WSDL
     * - documentation: Fare component number
     * - use: required
     * @var int
     */
    public $ComponentNo;
    /**
     * The BasisCode
     * Meta information extracted from the WSDL
     * - documentation: Fare basis code
     * - base: xs:string
     * - maxLength: 15
     * - minLength: 1
     * - pattern: [A-Z0-9]+(/[A-Z0-9]+)?
     * - use: required
     * @var string
     */
    public $BasisCode;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - documentation: Fare amount (note: last Flight in Fare Component) | Used for amounts, max 3 decimals
     * - base: xs:decimal
     * - fractionDigits: 3
     * - use: optional
     * @var float
     */
    public $Amount;
    /**
     * The Vendor
     * Meta information extracted from the WSDL
     * - documentation: Vendor (note: last Flight in Fare Component)
     * - type: xs:string
     * - use: optional
     * @var string
     */
    public $Vendor;
    /**
     * The SourceVendor
     * Meta information extracted from the WSDL
     * - documentation: Fare Source Vendor (note: last Flight in Fare Component)
     * - base: xs:string
     * - pattern: [0-9A-Z]{2,3}
     * - type: CarrierCode
     * - use: optional
     * @var string
     */
    public $SourceVendor;
    /**
     * The Tariff
     * Meta information extracted from the WSDL
     * - documentation: Tariff (note: last Flight in Fare Component)
     * - type: xs:string
     * - use: optional
     * @var string
     */
    public $Tariff;
    /**
     * The RuleNumber
     * Meta information extracted from the WSDL
     * - documentation: Rule Number (note: last Flight in Fare Component)
     * - type: xs:string
     * - use: optional
     * @var string
     */
    public $RuleNumber;
    /**
     * The BrandID
     * @var string
     */
    public $BrandID;
    /**
     * The ProgramID
     * Meta information extracted from the WSDL
     * - type: xs:int
     * @var int
     */
    public $ProgramID;
    /**
     * Constructor method for FareDetailsType
     * @uses FareDetailsType::setComponentNo()
     * @uses FareDetailsType::setBasisCode()
     * @uses FareDetailsType::setAmount()
     * @uses FareDetailsType::setVendor()
     * @uses FareDetailsType::setSourceVendor()
     * @uses FareDetailsType::setTariff()
     * @uses FareDetailsType::setRuleNumber()
     * @uses FareDetailsType::setBrandID()
     * @uses FareDetailsType::setProgramID()
     * @param int $componentNo
     * @param string $basisCode
     * @param float $amount
     * @param string $vendor
     * @param string $sourceVendor
     * @param string $tariff
     * @param string $ruleNumber
     * @param string $brandID
     * @param int $programID
     */
    public function __construct($componentNo = null, $basisCode = null, $amount = null, $vendor = null, $sourceVendor = null, $tariff = null, $ruleNumber = null, $brandID = null, $programID = null)
    {
        $this
            ->setComponentNo($componentNo)
            ->setBasisCode($basisCode)
            ->setAmount($amount)
            ->setVendor($vendor)
            ->setSourceVendor($sourceVendor)
            ->setTariff($tariff)
            ->setRuleNumber($ruleNumber)
            ->setBrandID($brandID)
            ->setProgramID($programID);
    }
    /**
     * Get ComponentNo value
     * @return int
     */
    public function getComponentNo()
    {
        return $this->ComponentNo;
    }
    /**
     * Set ComponentNo value
     * @param int $componentNo
     * @return \SabreSoap\StructType\FareDetailsType
     */
    public function setComponentNo($componentNo = null)
    {
        $this->ComponentNo = $componentNo;
        return $this;
    }
    /**
     * Get BasisCode value
     * @return string
     */
    public function getBasisCode()
    {
        return $this->BasisCode;
    }
    /**
     * Set BasisCode value
     * @param string $basisCode
     * @return \SabreSoap\StructType\FareDetailsType
     */
    public function setBasisCode($basisCode = null)
    {
        $this->BasisCode = $basisCode;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \SabreSoap\StructType\FareDetailsType
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Vendor value
     * @return string|null
     */
    public function getVendor()
    {
        return $this->Vendor;
    }
    /**
     * Set Vendor value
     * @param string $vendor
     * @return \SabreSoap\StructType\FareDetailsType
     */
    public function setVendor($vendor = null)
    {
        $this->Vendor = $vendor;
        return $this;
    }
    /**
     * Get SourceVendor value
     * @return string|null
     */
    public function getSourceVendor()
    {
        return $this->SourceVendor;
    }
    /**
     * Set SourceVendor value
     * @param string $sourceVendor
     * @return \SabreSoap\StructType\FareDetailsType
     */
    public function setSourceVendor($sourceVendor = null)
    {
        $this->SourceVendor = $sourceVendor;
        return $this;
    }
    /**
     * Get Tariff value
     * @return string|null
     */
    public function getTariff()
    {
        return $this->Tariff;
    }
    /**
     * Set Tariff value
     * @param string $tariff
     * @return \SabreSoap\StructType\FareDetailsType
     */
    public function setTariff($tariff = null)
    {
        $this->Tariff = $tariff;
        return $this;
    }
    /**
     * Get RuleNumber value
     * @return string|null
     */
    public function getRuleNumber()
    {
        return $this->RuleNumber;
    }
    /**
     * Set RuleNumber value
     * @param string $ruleNumber
     * @return \SabreSoap\StructType\FareDetailsType
     */
    public function setRuleNumber($ruleNumber = null)
    {
        $this->RuleNumber = $ruleNumber;
        return $this;
    }
    /**
     * Get BrandID value
     * @return string|null
     */
    public function getBrandID()
    {
        return $this->BrandID;
    }
    /**
     * Set BrandID value
     * @param string $brandID
     * @return \SabreSoap\StructType\FareDetailsType
     */
    public function setBrandID($brandID = null)
    {
        $this->BrandID = $brandID;
        return $this;
    }
    /**
     * Get ProgramID value
     * @return int|null
     */
    public function getProgramID()
    {
        return $this->ProgramID;
    }
    /**
     * Set ProgramID value
     * @param int $programID
     * @return \SabreSoap\StructType\FareDetailsType
     */
    public function setProgramID($programID = null)
    {
        $this->ProgramID = $programID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SabreSoap\StructType\FareDetailsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
