<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ErrorsType StructType
 * Meta information extracted from the WSDL
 * - documentation: A collection of errors that occurred during the processing of a message.
 * @subpackage Structs
 */
class ErrorsType extends AbstractStructBase
{
    /**
     * The Error
     * Meta information extracted from the WSDL
     * - documentation: Describes an error that occurred during the processing of an OTA message
     * - maxOccurs: unbounded
     * @var \SabreSoap\StructType\ErrorType[]
     */
    public $Error;
    /**
     * Constructor method for ErrorsType
     * @uses ErrorsType::setError()
     * @param \SabreSoap\StructType\ErrorType[] $error
     */
    public function __construct(array $error = array())
    {
        $this
            ->setError($error);
    }
    /**
     * Get Error value
     * @return \SabreSoap\StructType\ErrorType[]|null
     */
    public function getError()
    {
        return $this->Error;
    }
    /**
     * Set Error value
     * @param \SabreSoap\StructType\ErrorType[] $error
     * @return \SabreSoap\StructType\ErrorsType
     */
    public function setError(array $error = array())
    {
        $this->Error = $error;
        return $this;
    }
    /**
     * Add item to Error value
     * @throws \InvalidArgumentException
     * @param \SabreSoap\StructType\ErrorType $item
     * @return \SabreSoap\StructType\ErrorsType
     */
    public function addToError(\SabreSoap\StructType\ErrorType $item)
    {
        $this->Error[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SabreSoap\StructType\ErrorsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
