<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Error StructType
 * @subpackage Structs
 */
class Error extends AbstractStructBase
{
    /**
     * The errorCode
     * Meta information extracted from the WSDL
     * - base: string
     * - minLength: 1
     * - use: required
     * @var string
     */
    public $errorCode;
    /**
     * The severity
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $severity;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:Description
     * @var \SabreSoap\StructType\Description
     */
    public $Description;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * The id
     * Meta information extracted from the WSDL
     * - ref: tns:id
     * @var string
     */
    public $id;
    /**
     * The codeContext
     * Meta information extracted from the WSDL
     * - default: urn:oasis:names:tc:ebxml-msg:service:errors
     * @var string
     */
    public $codeContext;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - base: string
     * - minLength: 1
     * @var string
     */
    public $location;
    /**
     * Constructor method for Error
     * @uses Error::setErrorCode()
     * @uses Error::setSeverity()
     * @uses Error::setDescription()
     * @uses Error::setAny()
     * @uses Error::setId()
     * @uses Error::setCodeContext()
     * @uses Error::setLocation()
     * @param string $errorCode
     * @param string $severity
     * @param \SabreSoap\StructType\Description $description
     * @param \DOMDocument $any
     * @param string $id
     * @param string $codeContext
     * @param string $location
     */
    public function __construct($errorCode = null, $severity = null, \SabreSoap\StructType\Description $description = null, \DOMDocument $any = null, $id = null, $codeContext = 'urn:oasis:names:tc:ebxml-msg:service:errors', $location = null)
    {
        $this
            ->setErrorCode($errorCode)
            ->setSeverity($severity)
            ->setDescription($description)
            ->setAny($any)
            ->setId($id)
            ->setCodeContext($codeContext)
            ->setLocation($location);
    }
    /**
     * Get errorCode value
     * @return string
     */
    public function getErrorCode()
    {
        return $this->errorCode;
    }
    /**
     * Set errorCode value
     * @param string $errorCode
     * @return \SabreSoap\StructType\Error
     */
    public function setErrorCode($errorCode = null)
    {
        $this->errorCode = $errorCode;
        return $this;
    }
    /**
     * Get severity value
     * @return string
     */
    public function getSeverity()
    {
        return $this->severity;
    }
    /**
     * Set severity value
     * @param string $severity
     * @return \SabreSoap\StructType\Error
     */
    public function setSeverity($severity = null)
    {
        $this->severity = $severity;
        return $this;
    }
    /**
     * Get Description value
     * @return \SabreSoap\StructType\Description|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param \SabreSoap\StructType\Description $description
     * @return \SabreSoap\StructType\Error
     */
    public function setDescription(\SabreSoap\StructType\Description $description = null)
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \SabreSoap\StructType\Error
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \SabreSoap\StructType\Error
     */
    public function setId($id = null)
    {
        $this->id = $id;
        return $this;
    }
    /**
     * Get codeContext value
     * @return string|null
     */
    public function getCodeContext()
    {
        return $this->codeContext;
    }
    /**
     * Set codeContext value
     * @param string $codeContext
     * @return \SabreSoap\StructType\Error
     */
    public function setCodeContext($codeContext = 'urn:oasis:names:tc:ebxml-msg:service:errors')
    {
        $this->codeContext = $codeContext;
        return $this;
    }
    /**
     * Get location value
     * @return string|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param string $location
     * @return \SabreSoap\StructType\Error
     */
    public function setLocation($location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SabreSoap\StructType\Error
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
