<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Dimensions StructType
 * @subpackage Structs
 */
class Dimensions extends AbstractStructBase
{
    /**
     * The TravelTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\TravelTime
     */
    public $TravelTime;
    /**
     * The Carrier
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\Carrier
     */
    public $Carrier;
    /**
     * The OperatingDuplicate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\OperatingDuplicate
     */
    public $OperatingDuplicate;
    /**
     * The InboundOutboundPairing
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\InboundOutboundPairing
     */
    public $InboundOutboundPairing;
    /**
     * The TimeOfDay
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\TimeOfDay
     */
    public $TimeOfDay;
    /**
     * The StopsNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\StopsNumber
     */
    public $StopsNumber;
    /**
     * The PriceWeight
     * Meta information extracted from the WSDL
     * - base: xs:unsignedShort
     * - default: 10
     * - maxInclusive: 10
     * - minInclusive: 0
     * @var int
     */
    public $PriceWeight;
    /**
     * Constructor method for Dimensions
     * @uses Dimensions::setTravelTime()
     * @uses Dimensions::setCarrier()
     * @uses Dimensions::setOperatingDuplicate()
     * @uses Dimensions::setInboundOutboundPairing()
     * @uses Dimensions::setTimeOfDay()
     * @uses Dimensions::setStopsNumber()
     * @uses Dimensions::setPriceWeight()
     * @param \SabreSoap\StructType\TravelTime $travelTime
     * @param \SabreSoap\StructType\Carrier $carrier
     * @param \SabreSoap\StructType\OperatingDuplicate $operatingDuplicate
     * @param \SabreSoap\StructType\InboundOutboundPairing $inboundOutboundPairing
     * @param \SabreSoap\StructType\TimeOfDay $timeOfDay
     * @param \SabreSoap\StructType\StopsNumber $stopsNumber
     * @param int $priceWeight
     */
    public function __construct(\SabreSoap\StructType\TravelTime $travelTime = null, \SabreSoap\StructType\Carrier $carrier = null, \SabreSoap\StructType\OperatingDuplicate $operatingDuplicate = null, \SabreSoap\StructType\InboundOutboundPairing $inboundOutboundPairing = null, \SabreSoap\StructType\TimeOfDay $timeOfDay = null, \SabreSoap\StructType\StopsNumber $stopsNumber = null, $priceWeight = '10')
    {
        $this
            ->setTravelTime($travelTime)
            ->setCarrier($carrier)
            ->setOperatingDuplicate($operatingDuplicate)
            ->setInboundOutboundPairing($inboundOutboundPairing)
            ->setTimeOfDay($timeOfDay)
            ->setStopsNumber($stopsNumber)
            ->setPriceWeight($priceWeight);
    }
    /**
     * Get TravelTime value
     * @return \SabreSoap\StructType\TravelTime|null
     */
    public function getTravelTime()
    {
        return $this->TravelTime;
    }
    /**
     * Set TravelTime value
     * @param \SabreSoap\StructType\TravelTime $travelTime
     * @return \SabreSoap\StructType\Dimensions
     */
    public function setTravelTime(\SabreSoap\StructType\TravelTime $travelTime = null)
    {
        $this->TravelTime = $travelTime;
        return $this;
    }
    /**
     * Get Carrier value
     * @return \SabreSoap\StructType\Carrier|null
     */
    public function getCarrier()
    {
        return $this->Carrier;
    }
    /**
     * Set Carrier value
     * @param \SabreSoap\StructType\Carrier $carrier
     * @return \SabreSoap\StructType\Dimensions
     */
    public function setCarrier(\SabreSoap\StructType\Carrier $carrier = null)
    {
        $this->Carrier = $carrier;
        return $this;
    }
    /**
     * Get OperatingDuplicate value
     * @return \SabreSoap\StructType\OperatingDuplicate|null
     */
    public function getOperatingDuplicate()
    {
        return $this->OperatingDuplicate;
    }
    /**
     * Set OperatingDuplicate value
     * @param \SabreSoap\StructType\OperatingDuplicate $operatingDuplicate
     * @return \SabreSoap\StructType\Dimensions
     */
    public function setOperatingDuplicate(\SabreSoap\StructType\OperatingDuplicate $operatingDuplicate = null)
    {
        $this->OperatingDuplicate = $operatingDuplicate;
        return $this;
    }
    /**
     * Get InboundOutboundPairing value
     * @return \SabreSoap\StructType\InboundOutboundPairing|null
     */
    public function getInboundOutboundPairing()
    {
        return $this->InboundOutboundPairing;
    }
    /**
     * Set InboundOutboundPairing value
     * @param \SabreSoap\StructType\InboundOutboundPairing $inboundOutboundPairing
     * @return \SabreSoap\StructType\Dimensions
     */
    public function setInboundOutboundPairing(\SabreSoap\StructType\InboundOutboundPairing $inboundOutboundPairing = null)
    {
        $this->InboundOutboundPairing = $inboundOutboundPairing;
        return $this;
    }
    /**
     * Get TimeOfDay value
     * @return \SabreSoap\StructType\TimeOfDay|null
     */
    public function getTimeOfDay()
    {
        return $this->TimeOfDay;
    }
    /**
     * Set TimeOfDay value
     * @param \SabreSoap\StructType\TimeOfDay $timeOfDay
     * @return \SabreSoap\StructType\Dimensions
     */
    public function setTimeOfDay(\SabreSoap\StructType\TimeOfDay $timeOfDay = null)
    {
        $this->TimeOfDay = $timeOfDay;
        return $this;
    }
    /**
     * Get StopsNumber value
     * @return \SabreSoap\StructType\StopsNumber|null
     */
    public function getStopsNumber()
    {
        return $this->StopsNumber;
    }
    /**
     * Set StopsNumber value
     * @param \SabreSoap\StructType\StopsNumber $stopsNumber
     * @return \SabreSoap\StructType\Dimensions
     */
    public function setStopsNumber(\SabreSoap\StructType\StopsNumber $stopsNumber = null)
    {
        $this->StopsNumber = $stopsNumber;
        return $this;
    }
    /**
     * Get PriceWeight value
     * @return int|null
     */
    public function getPriceWeight()
    {
        return $this->PriceWeight;
    }
    /**
     * Set PriceWeight value
     * @param int $priceWeight
     * @return \SabreSoap\StructType\Dimensions
     */
    public function setPriceWeight($priceWeight = '10')
    {
        $this->PriceWeight = $priceWeight;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SabreSoap\StructType\Dimensions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
