<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CurrencyAmountType StructType
 * Meta information extracted from the WSDL
 * - documentation: Provides a monetary amount and the code of the currency in which this amount is expressed.
 * @subpackage Structs
 */
class CurrencyAmountType extends AbstractStructBase
{
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - documentation: Used for amounts, max 3 decimals
     * - base: xs:decimal
     * - fractionDigits: 3
     * @var float
     */
    public $Amount;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - documentation: Used for Alphabetic Strings, length exactly 3
     * - base: xs:string
     * - pattern: [a-zA-Z]{3}
     * @var string
     */
    public $CurrencyCode;
    /**
     * The DecimalPlaces
     * @var int
     */
    public $DecimalPlaces;
    /**
     * Constructor method for CurrencyAmountType
     * @uses CurrencyAmountType::setAmount()
     * @uses CurrencyAmountType::setCurrencyCode()
     * @uses CurrencyAmountType::setDecimalPlaces()
     * @param float $amount
     * @param string $currencyCode
     * @param int $decimalPlaces
     */
    public function __construct($amount = null, $currencyCode = null, $decimalPlaces = null)
    {
        $this
            ->setAmount($amount)
            ->setCurrencyCode($currencyCode)
            ->setDecimalPlaces($decimalPlaces);
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \SabreSoap\StructType\CurrencyAmountType
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \SabreSoap\StructType\CurrencyAmountType
     */
    public function setCurrencyCode($currencyCode = null)
    {
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get DecimalPlaces value
     * @return int|null
     */
    public function getDecimalPlaces()
    {
        return $this->DecimalPlaces;
    }
    /**
     * Set DecimalPlaces value
     * @param int $decimalPlaces
     * @return \SabreSoap\StructType\CurrencyAmountType
     */
    public function setDecimalPlaces($decimalPlaces = null)
    {
        $this->DecimalPlaces = $decimalPlaces;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SabreSoap\StructType\CurrencyAmountType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
