<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Cabin StructType
 * Meta information extracted from the WSDL
 * - documentation: This element specifies preffered cabin type.
 * @subpackage Structs
 */
class Cabin extends AbstractStructBase
{
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Type;
    /**
     * The Cabin
     * Meta information extracted from the WSDL
     * - default: Economy
     * @var string
     */
    public $Cabin;
    /**
     * Constructor method for Cabin
     * @uses Cabin::setType()
     * @uses Cabin::setCabin()
     * @param string $type
     * @param string $cabin
     */
    public function __construct($type = null, $cabin = 'Economy')
    {
        $this
            ->setType($type)
            ->setCabin($cabin);
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \SabreSoap\StructType\Cabin
     */
    public function setType($type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Cabin value
     * @return string|null
     */
    public function getCabin()
    {
        return $this->Cabin;
    }
    /**
     * Set Cabin value
     * @param string $cabin
     * @return \SabreSoap\StructType\Cabin
     */
    public function setCabin($cabin = 'Economy')
    {
        $this->Cabin = $cabin;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SabreSoap\StructType\Cabin
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
