<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ArunkType StructType
 * @subpackage Structs
 */
class ArunkType extends AbstractStructBase
{
    /**
     * The OriginLocation
     * Meta information extracted from the WSDL
     * - documentation: Origin code
     * @var \SabreSoap\StructType\RequestLocationType
     */
    public $OriginLocation;
    /**
     * The DestinationLocation
     * Meta information extracted from the WSDL
     * - documentation: Destination code
     * @var \SabreSoap\StructType\RequestLocationType
     */
    public $DestinationLocation;
    /**
     * The SideTrip
     * Meta information extracted from the WSDL
     * - documentation: Side trip information
     * - minOccurs: 0
     * @var \SabreSoap\StructType\SideTripType
     */
    public $SideTrip;
    /**
     * Constructor method for ArunkType
     * @uses ArunkType::setOriginLocation()
     * @uses ArunkType::setDestinationLocation()
     * @uses ArunkType::setSideTrip()
     * @param \SabreSoap\StructType\RequestLocationType $originLocation
     * @param \SabreSoap\StructType\RequestLocationType $destinationLocation
     * @param \SabreSoap\StructType\SideTripType $sideTrip
     */
    public function __construct(\SabreSoap\StructType\RequestLocationType $originLocation = null, \SabreSoap\StructType\RequestLocationType $destinationLocation = null, \SabreSoap\StructType\SideTripType $sideTrip = null)
    {
        $this
            ->setOriginLocation($originLocation)
            ->setDestinationLocation($destinationLocation)
            ->setSideTrip($sideTrip);
    }
    /**
     * Get OriginLocation value
     * @return \SabreSoap\StructType\RequestLocationType|null
     */
    public function getOriginLocation()
    {
        return $this->OriginLocation;
    }
    /**
     * Set OriginLocation value
     * @param \SabreSoap\StructType\RequestLocationType $originLocation
     * @return \SabreSoap\StructType\ArunkType
     */
    public function setOriginLocation(\SabreSoap\StructType\RequestLocationType $originLocation = null)
    {
        $this->OriginLocation = $originLocation;
        return $this;
    }
    /**
     * Get DestinationLocation value
     * @return \SabreSoap\StructType\RequestLocationType|null
     */
    public function getDestinationLocation()
    {
        return $this->DestinationLocation;
    }
    /**
     * Set DestinationLocation value
     * @param \SabreSoap\StructType\RequestLocationType $destinationLocation
     * @return \SabreSoap\StructType\ArunkType
     */
    public function setDestinationLocation(\SabreSoap\StructType\RequestLocationType $destinationLocation = null)
    {
        $this->DestinationLocation = $destinationLocation;
        return $this;
    }
    /**
     * Get SideTrip value
     * @return \SabreSoap\StructType\SideTripType|null
     */
    public function getSideTrip()
    {
        return $this->SideTrip;
    }
    /**
     * Set SideTrip value
     * @param \SabreSoap\StructType\SideTripType $sideTrip
     * @return \SabreSoap\StructType\ArunkType
     */
    public function setSideTrip(\SabreSoap\StructType\SideTripType $sideTrip = null)
    {
        $this->SideTrip = $sideTrip;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SabreSoap\StructType\ArunkType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
