<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AlternateLocationLowestFaresType StructType
 * Meta information extracted from the WSDL
 * - documentation: IntelliSell Type . lowest fare for alternate origin / destination pair.
 * @subpackage Structs
 */
class AlternateLocationLowestFaresType extends AbstractStructBase
{
    /**
     * The OriginLocation
     * @var \SabreSoap\StructType\ResponseLocationType
     */
    public $OriginLocation;
    /**
     * The DestinationLocation
     * @var \SabreSoap\StructType\ResponseLocationType
     */
    public $DestinationLocation;
    /**
     * The LowestFare
     * @var \SabreSoap\StructType\CurrencyAmountType
     */
    public $LowestFare;
    /**
     * Constructor method for AlternateLocationLowestFaresType
     * @uses AlternateLocationLowestFaresType::setOriginLocation()
     * @uses AlternateLocationLowestFaresType::setDestinationLocation()
     * @uses AlternateLocationLowestFaresType::setLowestFare()
     * @param \SabreSoap\StructType\ResponseLocationType $originLocation
     * @param \SabreSoap\StructType\ResponseLocationType $destinationLocation
     * @param \SabreSoap\StructType\CurrencyAmountType $lowestFare
     */
    public function __construct(\SabreSoap\StructType\ResponseLocationType $originLocation = null, \SabreSoap\StructType\ResponseLocationType $destinationLocation = null, \SabreSoap\StructType\CurrencyAmountType $lowestFare = null)
    {
        $this
            ->setOriginLocation($originLocation)
            ->setDestinationLocation($destinationLocation)
            ->setLowestFare($lowestFare);
    }
    /**
     * Get OriginLocation value
     * @return \SabreSoap\StructType\ResponseLocationType|null
     */
    public function getOriginLocation()
    {
        return $this->OriginLocation;
    }
    /**
     * Set OriginLocation value
     * @param \SabreSoap\StructType\ResponseLocationType $originLocation
     * @return \SabreSoap\StructType\AlternateLocationLowestFaresType
     */
    public function setOriginLocation(\SabreSoap\StructType\ResponseLocationType $originLocation = null)
    {
        $this->OriginLocation = $originLocation;
        return $this;
    }
    /**
     * Get DestinationLocation value
     * @return \SabreSoap\StructType\ResponseLocationType|null
     */
    public function getDestinationLocation()
    {
        return $this->DestinationLocation;
    }
    /**
     * Set DestinationLocation value
     * @param \SabreSoap\StructType\ResponseLocationType $destinationLocation
     * @return \SabreSoap\StructType\AlternateLocationLowestFaresType
     */
    public function setDestinationLocation(\SabreSoap\StructType\ResponseLocationType $destinationLocation = null)
    {
        $this->DestinationLocation = $destinationLocation;
        return $this;
    }
    /**
     * Get LowestFare value
     * @return \SabreSoap\StructType\CurrencyAmountType|null
     */
    public function getLowestFare()
    {
        return $this->LowestFare;
    }
    /**
     * Set LowestFare value
     * @param \SabreSoap\StructType\CurrencyAmountType $lowestFare
     * @return \SabreSoap\StructType\AlternateLocationLowestFaresType
     */
    public function setLowestFare(\SabreSoap\StructType\CurrencyAmountType $lowestFare = null)
    {
        $this->LowestFare = $lowestFare;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SabreSoap\StructType\AlternateLocationLowestFaresType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
