<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirTravelerType StructType
 * Meta information extracted from the WSDL
 * - documentation: Information about the person traveling. Gender - the gender of the customer, if needed. BirthDate - Date of Birth. Currency - the preferred currency in which monetary amounts should be returned.
 * @subpackage Structs
 */
class AirTravelerType extends AbstractStructBase
{
    /**
     * The PassengerTypeCode
     * Meta information extracted from the WSDL
     * - documentation: A three-letter code representing passenger type (e.g. .ADT. for adult, .CNN. for child) | Used for Alphabetic Strings, length exactly 3
     * - base: xs:string
     * - pattern: [a-zA-Z]{3}
     * - use: required
     * @var string
     */
    public $PassengerTypeCode;
    /**
     * The ProfileRef
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\ProfileRef
     */
    public $ProfileRef;
    /**
     * The PersonName
     * @var \SabreSoap\StructType\PersonNameType
     */
    public $PersonName;
    /**
     * The Telephone
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \SabreSoap\StructType\TelephoneType[]
     */
    public $Telephone;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var \SabreSoap\StructType\EmailType[]
     */
    public $Email;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \SabreSoap\StructType\AddressType[]
     */
    public $Address;
    /**
     * The CustLoyalty
     * Meta information extracted from the WSDL
     * - documentation: Specify a customer loyalty program.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \SabreSoap\StructType\CustLoyaltyType[]
     */
    public $CustLoyalty;
    /**
     * The Document
     * Meta information extracted from the WSDL
     * - maxOccurs: 10
     * - minOccurs: 0
     * @var \SabreSoap\StructType\DocumentType[]
     */
    public $Document;
    /**
     * The PassengerTypeQuantity
     * Meta information extracted from the WSDL
     * - documentation: Define information on the number of passengers of a specific type.
     * - minOccurs: 0
     * @var \SabreSoap\StructType\PassengerTypeQuantityType
     */
    public $PassengerTypeQuantity;
    /**
     * The TravelerRefNumber
     * Meta information extracted from the WSDL
     * - documentation: Direct reference of traveler assigned by requesting system. Used as a cross reference between data segments.
     * @var \SabreSoap\StructType\TravelerRefNumberType
     */
    public $TravelerRefNumber;
    /**
     * The FlightSegmentRPHs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\FlightSegmentRPHs
     */
    public $FlightSegmentRPHs;
    /**
     * The BirthDate
     * Meta information extracted from the WSDL
     * - documentation: Date of Birth.
     * @var string
     */
    public $BirthDate;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - documentation: The preferred currency in which monetary amounts should be returned. | Used for Alphabetic Strings, length exactly 3
     * - base: xs:string
     * - pattern: [a-zA-Z]{3}
     * @var string
     */
    public $CurrencyCode;
    /**
     * The AccompaniedByInfant
     * Meta information extracted from the WSDL
     * - documentation: Indicates if an infant accompanying a traveler is with or without a seat.
     * - use: optional
     * @var bool
     */
    public $AccompaniedByInfant;
    /**
     * The Gender
     * @var string
     */
    public $Gender;
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * Constructor method for AirTravelerType
     * @uses AirTravelerType::setPassengerTypeCode()
     * @uses AirTravelerType::setProfileRef()
     * @uses AirTravelerType::setPersonName()
     * @uses AirTravelerType::setTelephone()
     * @uses AirTravelerType::setEmail()
     * @uses AirTravelerType::setAddress()
     * @uses AirTravelerType::setCustLoyalty()
     * @uses AirTravelerType::setDocument()
     * @uses AirTravelerType::setPassengerTypeQuantity()
     * @uses AirTravelerType::setTravelerRefNumber()
     * @uses AirTravelerType::setFlightSegmentRPHs()
     * @uses AirTravelerType::setBirthDate()
     * @uses AirTravelerType::setCurrencyCode()
     * @uses AirTravelerType::setAccompaniedByInfant()
     * @uses AirTravelerType::setGender()
     * @uses AirTravelerType::setShareSynchInd()
     * @uses AirTravelerType::setShareMarketInd()
     * @param string $passengerTypeCode
     * @param \SabreSoap\StructType\ProfileRef $profileRef
     * @param \SabreSoap\StructType\PersonNameType $personName
     * @param \SabreSoap\StructType\TelephoneType[] $telephone
     * @param \SabreSoap\StructType\EmailType[] $email
     * @param \SabreSoap\StructType\AddressType[] $address
     * @param \SabreSoap\StructType\CustLoyaltyType[] $custLoyalty
     * @param \SabreSoap\StructType\DocumentType[] $document
     * @param \SabreSoap\StructType\PassengerTypeQuantityType $passengerTypeQuantity
     * @param \SabreSoap\StructType\TravelerRefNumberType $travelerRefNumber
     * @param \SabreSoap\StructType\FlightSegmentRPHs $flightSegmentRPHs
     * @param string $birthDate
     * @param string $currencyCode
     * @param bool $accompaniedByInfant
     * @param string $gender
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     */
    public function __construct($passengerTypeCode = null, \SabreSoap\StructType\ProfileRef $profileRef = null, \SabreSoap\StructType\PersonNameType $personName = null, array $telephone = array(), array $email = array(), array $address = array(), array $custLoyalty = array(), array $document = array(), \SabreSoap\StructType\PassengerTypeQuantityType $passengerTypeQuantity = null, \SabreSoap\StructType\TravelerRefNumberType $travelerRefNumber = null, \SabreSoap\StructType\FlightSegmentRPHs $flightSegmentRPHs = null, $birthDate = null, $currencyCode = null, $accompaniedByInfant = null, $gender = null, $shareSynchInd = null, $shareMarketInd = null)
    {
        $this
            ->setPassengerTypeCode($passengerTypeCode)
            ->setProfileRef($profileRef)
            ->setPersonName($personName)
            ->setTelephone($telephone)
            ->setEmail($email)
            ->setAddress($address)
            ->setCustLoyalty($custLoyalty)
            ->setDocument($document)
            ->setPassengerTypeQuantity($passengerTypeQuantity)
            ->setTravelerRefNumber($travelerRefNumber)
            ->setFlightSegmentRPHs($flightSegmentRPHs)
            ->setBirthDate($birthDate)
            ->setCurrencyCode($currencyCode)
            ->setAccompaniedByInfant($accompaniedByInfant)
            ->setGender($gender)
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd);
    }
    /**
     * Get PassengerTypeCode value
     * @return string
     */
    public function getPassengerTypeCode()
    {
        return $this->PassengerTypeCode;
    }
    /**
     * Set PassengerTypeCode value
     * @param string $passengerTypeCode
     * @return \SabreSoap\StructType\AirTravelerType
     */
    public function setPassengerTypeCode($passengerTypeCode = null)
    {
        $this->PassengerTypeCode = $passengerTypeCode;
        return $this;
    }
    /**
     * Get ProfileRef value
     * @return \SabreSoap\StructType\ProfileRef|null
     */
    public function getProfileRef()
    {
        return $this->ProfileRef;
    }
    /**
     * Set ProfileRef value
     * @param \SabreSoap\StructType\ProfileRef $profileRef
     * @return \SabreSoap\StructType\AirTravelerType
     */
    public function setProfileRef(\SabreSoap\StructType\ProfileRef $profileRef = null)
    {
        $this->ProfileRef = $profileRef;
        return $this;
    }
    /**
     * Get PersonName value
     * @return \SabreSoap\StructType\PersonNameType|null
     */
    public function getPersonName()
    {
        return $this->PersonName;
    }
    /**
     * Set PersonName value
     * @param \SabreSoap\StructType\PersonNameType $personName
     * @return \SabreSoap\StructType\AirTravelerType
     */
    public function setPersonName(\SabreSoap\StructType\PersonNameType $personName = null)
    {
        $this->PersonName = $personName;
        return $this;
    }
    /**
     * Get Telephone value
     * @return \SabreSoap\StructType\TelephoneType[]|null
     */
    public function getTelephone()
    {
        return $this->Telephone;
    }
    /**
     * Set Telephone value
     * @param \SabreSoap\StructType\TelephoneType[] $telephone
     * @return \SabreSoap\StructType\AirTravelerType
     */
    public function setTelephone(array $telephone = array())
    {
        $this->Telephone = $telephone;
        return $this;
    }
    /**
     * Add item to Telephone value
     * @throws \InvalidArgumentException
     * @param \SabreSoap\StructType\TelephoneType $item
     * @return \SabreSoap\StructType\AirTravelerType
     */
    public function addToTelephone(\SabreSoap\StructType\TelephoneType $item)
    {
        $this->Telephone[] = $item;
        return $this;
    }
    /**
     * Get Email value
     * @return \SabreSoap\StructType\EmailType[]|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param \SabreSoap\StructType\EmailType[] $email
     * @return \SabreSoap\StructType\AirTravelerType
     */
    public function setEmail(array $email = array())
    {
        $this->Email = $email;
        return $this;
    }
    /**
     * Add item to Email value
     * @throws \InvalidArgumentException
     * @param \SabreSoap\StructType\EmailType $item
     * @return \SabreSoap\StructType\AirTravelerType
     */
    public function addToEmail(\SabreSoap\StructType\EmailType $item)
    {
        $this->Email[] = $item;
        return $this;
    }
    /**
     * Get Address value
     * @return \SabreSoap\StructType\AddressType[]|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \SabreSoap\StructType\AddressType[] $address
     * @return \SabreSoap\StructType\AirTravelerType
     */
    public function setAddress(array $address = array())
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Add item to Address value
     * @throws \InvalidArgumentException
     * @param \SabreSoap\StructType\AddressType $item
     * @return \SabreSoap\StructType\AirTravelerType
     */
    public function addToAddress(\SabreSoap\StructType\AddressType $item)
    {
        $this->Address[] = $item;
        return $this;
    }
    /**
     * Get CustLoyalty value
     * @return \SabreSoap\StructType\CustLoyaltyType[]|null
     */
    public function getCustLoyalty()
    {
        return $this->CustLoyalty;
    }
    /**
     * Set CustLoyalty value
     * @param \SabreSoap\StructType\CustLoyaltyType[] $custLoyalty
     * @return \SabreSoap\StructType\AirTravelerType
     */
    public function setCustLoyalty(array $custLoyalty = array())
    {
        $this->CustLoyalty = $custLoyalty;
        return $this;
    }
    /**
     * Add item to CustLoyalty value
     * @throws \InvalidArgumentException
     * @param \SabreSoap\StructType\CustLoyaltyType $item
     * @return \SabreSoap\StructType\AirTravelerType
     */
    public function addToCustLoyalty(\SabreSoap\StructType\CustLoyaltyType $item)
    {
        $this->CustLoyalty[] = $item;
        return $this;
    }
    /**
     * Get Document value
     * @return \SabreSoap\StructType\DocumentType[]|null
     */
    public function getDocument()
    {
        return $this->Document;
    }
    /**
     * Set Document value
     * @param \SabreSoap\StructType\DocumentType[] $document
     * @return \SabreSoap\StructType\AirTravelerType
     */
    public function setDocument(array $document = array())
    {
        $this->Document = $document;
        return $this;
    }
    /**
     * Add item to Document value
     * @throws \InvalidArgumentException
     * @param \SabreSoap\StructType\DocumentType $item
     * @return \SabreSoap\StructType\AirTravelerType
     */
    public function addToDocument(\SabreSoap\StructType\DocumentType $item)
    {
        $this->Document[] = $item;
        return $this;
    }
    /**
     * Get PassengerTypeQuantity value
     * @return \SabreSoap\StructType\PassengerTypeQuantityType|null
     */
    public function getPassengerTypeQuantity()
    {
        return $this->PassengerTypeQuantity;
    }
    /**
     * Set PassengerTypeQuantity value
     * @param \SabreSoap\StructType\PassengerTypeQuantityType $passengerTypeQuantity
     * @return \SabreSoap\StructType\AirTravelerType
     */
    public function setPassengerTypeQuantity(\SabreSoap\StructType\PassengerTypeQuantityType $passengerTypeQuantity = null)
    {
        $this->PassengerTypeQuantity = $passengerTypeQuantity;
        return $this;
    }
    /**
     * Get TravelerRefNumber value
     * @return \SabreSoap\StructType\TravelerRefNumberType|null
     */
    public function getTravelerRefNumber()
    {
        return $this->TravelerRefNumber;
    }
    /**
     * Set TravelerRefNumber value
     * @param \SabreSoap\StructType\TravelerRefNumberType $travelerRefNumber
     * @return \SabreSoap\StructType\AirTravelerType
     */
    public function setTravelerRefNumber(\SabreSoap\StructType\TravelerRefNumberType $travelerRefNumber = null)
    {
        $this->TravelerRefNumber = $travelerRefNumber;
        return $this;
    }
    /**
     * Get FlightSegmentRPHs value
     * @return \SabreSoap\StructType\FlightSegmentRPHs|null
     */
    public function getFlightSegmentRPHs()
    {
        return $this->FlightSegmentRPHs;
    }
    /**
     * Set FlightSegmentRPHs value
     * @param \SabreSoap\StructType\FlightSegmentRPHs $flightSegmentRPHs
     * @return \SabreSoap\StructType\AirTravelerType
     */
    public function setFlightSegmentRPHs(\SabreSoap\StructType\FlightSegmentRPHs $flightSegmentRPHs = null)
    {
        $this->FlightSegmentRPHs = $flightSegmentRPHs;
        return $this;
    }
    /**
     * Get BirthDate value
     * @return string|null
     */
    public function getBirthDate()
    {
        return $this->BirthDate;
    }
    /**
     * Set BirthDate value
     * @param string $birthDate
     * @return \SabreSoap\StructType\AirTravelerType
     */
    public function setBirthDate($birthDate = null)
    {
        $this->BirthDate = $birthDate;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \SabreSoap\StructType\AirTravelerType
     */
    public function setCurrencyCode($currencyCode = null)
    {
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get AccompaniedByInfant value
     * @return bool|null
     */
    public function getAccompaniedByInfant()
    {
        return $this->AccompaniedByInfant;
    }
    /**
     * Set AccompaniedByInfant value
     * @param bool $accompaniedByInfant
     * @return \SabreSoap\StructType\AirTravelerType
     */
    public function setAccompaniedByInfant($accompaniedByInfant = null)
    {
        $this->AccompaniedByInfant = $accompaniedByInfant;
        return $this;
    }
    /**
     * Get Gender value
     * @return string|null
     */
    public function getGender()
    {
        return $this->Gender;
    }
    /**
     * Set Gender value
     * @param string $gender
     * @return \SabreSoap\StructType\AirTravelerType
     */
    public function setGender($gender = null)
    {
        $this->Gender = $gender;
        return $this;
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \SabreSoap\StructType\AirTravelerType
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \SabreSoap\StructType\AirTravelerType
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SabreSoap\StructType\AirTravelerType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
