<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdditionalFares StructType
 * @subpackage Structs
 */
class AdditionalFares extends AbstractStructBase
{
    /**
     * The AirItineraryPricingInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\AirItineraryPricingInfo
     */
    public $AirItineraryPricingInfo;
    /**
     * The Notes
     * Meta information extracted from the WSDL
     * - documentation: Provides for free form descriptive information for the priced itinerary.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \SabreSoap\StructType\FreeTextType[]
     */
    public $Notes;
    /**
     * The TicketingInfo
     * Meta information extracted from the WSDL
     * - documentation: Information about ticketing (including eTicketNumber).
     * - minOccurs: 0
     * @var \SabreSoap\StructType\TicketingInfoRS_Type
     */
    public $TicketingInfo;
    /**
     * The MultipleTickets
     * Meta information extracted from the WSDL
     * - documentation: Indicates that itinerary should be sold on multiple separate tickets
     * - use: optional
     * @var bool
     */
    public $MultipleTickets;
    /**
     * Constructor method for AdditionalFares
     * @uses AdditionalFares::setAirItineraryPricingInfo()
     * @uses AdditionalFares::setNotes()
     * @uses AdditionalFares::setTicketingInfo()
     * @uses AdditionalFares::setMultipleTickets()
     * @param \SabreSoap\StructType\AirItineraryPricingInfo $airItineraryPricingInfo
     * @param \SabreSoap\StructType\FreeTextType[] $notes
     * @param \SabreSoap\StructType\TicketingInfoRS_Type $ticketingInfo
     * @param bool $multipleTickets
     */
    public function __construct(\SabreSoap\StructType\AirItineraryPricingInfo $airItineraryPricingInfo = null, array $notes = array(), \SabreSoap\StructType\TicketingInfoRS_Type $ticketingInfo = null, $multipleTickets = null)
    {
        $this
            ->setAirItineraryPricingInfo($airItineraryPricingInfo)
            ->setNotes($notes)
            ->setTicketingInfo($ticketingInfo)
            ->setMultipleTickets($multipleTickets);
    }
    /**
     * Get AirItineraryPricingInfo value
     * @return \SabreSoap\StructType\AirItineraryPricingInfo|null
     */
    public function getAirItineraryPricingInfo()
    {
        return $this->AirItineraryPricingInfo;
    }
    /**
     * Set AirItineraryPricingInfo value
     * @param \SabreSoap\StructType\AirItineraryPricingInfo $airItineraryPricingInfo
     * @return \SabreSoap\StructType\AdditionalFares
     */
    public function setAirItineraryPricingInfo(\SabreSoap\StructType\AirItineraryPricingInfo $airItineraryPricingInfo = null)
    {
        $this->AirItineraryPricingInfo = $airItineraryPricingInfo;
        return $this;
    }
    /**
     * Get Notes value
     * @return \SabreSoap\StructType\FreeTextType[]|null
     */
    public function getNotes()
    {
        return $this->Notes;
    }
    /**
     * Set Notes value
     * @param \SabreSoap\StructType\FreeTextType[] $notes
     * @return \SabreSoap\StructType\AdditionalFares
     */
    public function setNotes(array $notes = array())
    {
        $this->Notes = $notes;
        return $this;
    }
    /**
     * Add item to Notes value
     * @throws \InvalidArgumentException
     * @param \SabreSoap\StructType\FreeTextType $item
     * @return \SabreSoap\StructType\AdditionalFares
     */
    public function addToNotes(\SabreSoap\StructType\FreeTextType $item)
    {
        $this->Notes[] = $item;
        return $this;
    }
    /**
     * Get TicketingInfo value
     * @return \SabreSoap\StructType\TicketingInfoRS_Type|null
     */
    public function getTicketingInfo()
    {
        return $this->TicketingInfo;
    }
    /**
     * Set TicketingInfo value
     * @param \SabreSoap\StructType\TicketingInfoRS_Type $ticketingInfo
     * @return \SabreSoap\StructType\AdditionalFares
     */
    public function setTicketingInfo(\SabreSoap\StructType\TicketingInfoRS_Type $ticketingInfo = null)
    {
        $this->TicketingInfo = $ticketingInfo;
        return $this;
    }
    /**
     * Get MultipleTickets value
     * @return bool|null
     */
    public function getMultipleTickets()
    {
        return $this->MultipleTickets;
    }
    /**
     * Set MultipleTickets value
     * @param bool $multipleTickets
     * @return \SabreSoap\StructType\AdditionalFares
     */
    public function setMultipleTickets($multipleTickets = null)
    {
        $this->MultipleTickets = $multipleTickets;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SabreSoap\StructType\AdditionalFares
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
