<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Acknowledgment StructType
 * @subpackage Structs
 */
class Acknowledgment extends AbstractStructBase
{
    /**
     * The Timestamp
     * Meta information extracted from the WSDL
     * - ref: tns:Timestamp
     * @var string
     */
    public $Timestamp;
    /**
     * The RefToMessageId
     * Meta information extracted from the WSDL
     * - base: string
     * - minLength: 1
     * - ref: tns:RefToMessageId
     * @var string
     */
    public $RefToMessageId;
    /**
     * The From
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:From
     * @var \SabreSoap\StructType\From
     */
    public $From;
    /**
     * The Reference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: tns:Reference
     * @var \SabreSoap\StructType\Reference[]
     */
    public $Reference;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * The actor
     * Meta information extracted from the WSDL
     * - ref: soap:actor
     * @var string
     */
    public $actor;
    /**
     * The id
     * @var string
     */
    public $id;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - base: string
     * - minLength: 1
     * @var string
     */
    public $version;
    /**
     * Constructor method for Acknowledgment
     * @uses Acknowledgment::setTimestamp()
     * @uses Acknowledgment::setRefToMessageId()
     * @uses Acknowledgment::setFrom()
     * @uses Acknowledgment::setReference()
     * @uses Acknowledgment::setAny()
     * @uses Acknowledgment::setActor()
     * @uses Acknowledgment::setId()
     * @uses Acknowledgment::setVersion()
     * @param string $timestamp
     * @param string $refToMessageId
     * @param \SabreSoap\StructType\From $from
     * @param \SabreSoap\StructType\Reference[] $reference
     * @param \DOMDocument $any
     * @param string $actor
     * @param string $id
     * @param string $version
     */
    public function __construct($timestamp = null, $refToMessageId = null, \SabreSoap\StructType\From $from = null, array $reference = array(), \DOMDocument $any = null, $actor = null, $id = null, $version = null)
    {
        $this
            ->setTimestamp($timestamp)
            ->setRefToMessageId($refToMessageId)
            ->setFrom($from)
            ->setReference($reference)
            ->setAny($any)
            ->setActor($actor)
            ->setId($id)
            ->setVersion($version);
    }
    /**
     * Get Timestamp value
     * @return string|null
     */
    public function getTimestamp()
    {
        return $this->Timestamp;
    }
    /**
     * Set Timestamp value
     * @param string $timestamp
     * @return \SabreSoap\StructType\Acknowledgment
     */
    public function setTimestamp($timestamp = null)
    {
        $this->Timestamp = $timestamp;
        return $this;
    }
    /**
     * Get RefToMessageId value
     * @return string|null
     */
    public function getRefToMessageId()
    {
        return $this->RefToMessageId;
    }
    /**
     * Set RefToMessageId value
     * @param string $refToMessageId
     * @return \SabreSoap\StructType\Acknowledgment
     */
    public function setRefToMessageId($refToMessageId = null)
    {
        $this->RefToMessageId = $refToMessageId;
        return $this;
    }
    /**
     * Get From value
     * @return \SabreSoap\StructType\From|null
     */
    public function getFrom()
    {
        return $this->From;
    }
    /**
     * Set From value
     * @param \SabreSoap\StructType\From $from
     * @return \SabreSoap\StructType\Acknowledgment
     */
    public function setFrom(\SabreSoap\StructType\From $from = null)
    {
        $this->From = $from;
        return $this;
    }
    /**
     * Get Reference value
     * @return \SabreSoap\StructType\Reference[]|null
     */
    public function getReference()
    {
        return $this->Reference;
    }
    /**
     * Set Reference value
     * @param \SabreSoap\StructType\Reference[] $reference
     * @return \SabreSoap\StructType\Acknowledgment
     */
    public function setReference(array $reference = array())
    {
        $this->Reference = $reference;
        return $this;
    }
    /**
     * Add item to Reference value
     * @throws \InvalidArgumentException
     * @param \SabreSoap\StructType\Reference $item
     * @return \SabreSoap\StructType\Acknowledgment
     */
    public function addToReference(\SabreSoap\StructType\Reference $item)
    {
        $this->Reference[] = $item;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \SabreSoap\StructType\Acknowledgment
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
    /**
     * Get actor value
     * @return string|null
     */
    public function getActor()
    {
        return $this->actor;
    }
    /**
     * Set actor value
     * @param string $actor
     * @return \SabreSoap\StructType\Acknowledgment
     */
    public function setActor($actor = null)
    {
        $this->actor = $actor;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \SabreSoap\StructType\Acknowledgment
     */
    public function setId($id = null)
    {
        $this->id = $id;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \SabreSoap\StructType\Acknowledgment
     */
    public function setVersion($version = null)
    {
        $this->version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SabreSoap\StructType\Acknowledgment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
