<?php

namespace SabreSoap\EnumType;

/**
 * This class stands for RequestType EnumType
 * Meta information extracted from the WSDL
 * - documentation: Used to specify if the request is an usual Exchange request (basic) or an Exchange Context Shopping request (context). When not specified, basic is assumed.
 * @subpackage Enumerations
 */
class RequestType
{
    /**
     * Constant for value 'basic'
     * @return string 'basic'
     */
    const VALUE_BASIC = 'basic';
    /**
     * Constant for value 'context'
     * @return string 'context'
     */
    const VALUE_CONTEXT = 'context';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BASIC
     * @uses self::VALUE_CONTEXT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BASIC,
            self::VALUE_CONTEXT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
