<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SourceBookingChannelType StructType
 * Meta information extracted from the WSDL
 * - documentation: Specifies the booking channel type and whether it is the primary means of connectivity of the source.
 * @subpackage Structs
 */
class SourceBookingChannelType extends BookingChannelType
{
    /**
     * The CompanyName
     * Meta information extracted from the WSDL
     * - documentation: Identifies the company that is associated with the booking channel.
     * - minOccurs: 0
     * @var \SabreSoap\StructType\CompanyNameType
     */
    public $CompanyName;
    /**
     * Constructor method for SourceBookingChannelType
     * @uses SourceBookingChannelType::setCompanyName()
     * @param \SabreSoap\StructType\CompanyNameType $companyName
     */
    public function __construct(\SabreSoap\StructType\CompanyNameType $companyName = null)
    {
        $this
            ->setCompanyName($companyName);
    }
    /**
     * Get CompanyName value
     * @return \SabreSoap\StructType\CompanyNameType|null
     */
    public function getCompanyName()
    {
        return $this->CompanyName;
    }
    /**
     * Set CompanyName value
     * @param \SabreSoap\StructType\CompanyNameType $companyName
     * @return \SabreSoap\StructType\SourceBookingChannelType
     */
    public function setCompanyName(\SabreSoap\StructType\CompanyNameType $companyName = null)
    {
        $this->CompanyName = $companyName;
        return $this;
    }
}
