<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MaxPrice StructType
 * Meta information extracted from the WSDL
 * - documentation: Maximum price returned from LFE service.
 * @subpackage Structs
 */
class MaxPrice extends AbstractStructBase
{
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - documentation: Used for amounts, max 3 decimals
     * - base: xs:decimal
     * - fractionDigits: 3
     * @var float
     */
    public $Value;
    /**
     * Constructor method for MaxPrice
     * @uses MaxPrice::setValue()
     * @param float $value
     */
    public function __construct($value = null)
    {
        $this
            ->setValue($value);
    }
    /**
     * Get Value value
     * @return float|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param float $value
     * @return \SabreSoap\StructType\MaxPrice
     */
    public function setValue($value = null)
    {
        $this->Value = $value;
        return $this;
    }
}
