<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Carrier StructType
 * Meta information extracted from the WSDL
 * - type: CarrierCode
 * - use: required
 * @subpackage Structs
 */
class Carrier extends AbstractStructBase
{
    /**
     * The Weight
     * Meta information extracted from the WSDL
     * - base: xs:integer
     * - maxInclusive: 10
     * - minInclusive: 1
     * - use: required
     * @var int
     */
    public $Weight;
    /**
     * The Default
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\_Default
     */
    public $Default;
    /**
     * The Override
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \SabreSoap\StructType\Override[]
     */
    public $Override;
    /**
     * The OnlineIndicator
     * Meta information extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $OnlineIndicator;
    /**
     * Constructor method for Carrier
     * @uses Carrier::setWeight()
     * @uses Carrier::setDefault()
     * @uses Carrier::setOverride()
     * @uses Carrier::setOnlineIndicator()
     * @param int $weight
     * @param \SabreSoap\StructType\_Default $default
     * @param \SabreSoap\StructType\Override[] $override
     * @param bool $onlineIndicator
     */
    public function __construct($weight = null, \SabreSoap\StructType\_Default $default = null, array $override = array(), $onlineIndicator = false)
    {
        $this
            ->setWeight($weight)
            ->setDefault($default)
            ->setOverride($override)
            ->setOnlineIndicator($onlineIndicator);
    }
    /**
     * Get Weight value
     * @return int
     */
    public function getWeight()
    {
        return $this->Weight;
    }
    /**
     * Set Weight value
     * @param int $weight
     * @return \SabreSoap\StructType\Carrier
     */
    public function setWeight($weight = null)
    {
        $this->Weight = $weight;
        return $this;
    }
    /**
     * Get Default value
     * @return \SabreSoap\StructType\_Default|null
     */
    public function getDefault()
    {
        return $this->Default;
    }
    /**
     * Set Default value
     * @param \SabreSoap\StructType\_Default $default
     * @return \SabreSoap\StructType\Carrier
     */
    public function setDefault(\SabreSoap\StructType\_Default $default = null)
    {
        $this->Default = $default;
        return $this;
    }
    /**
     * Get Override value
     * @return \SabreSoap\StructType\Override[]|null
     */
    public function getOverride()
    {
        return $this->Override;
    }
    /**
     * Set Override value
     * @param \SabreSoap\StructType\Override[] $override
     * @return \SabreSoap\StructType\Carrier
     */
    public function setOverride(array $override = array())
    {
        $this->Override = $override;
        return $this;
    }
    /**
     * Add item to Override value
     * @throws \InvalidArgumentException
     * @param \SabreSoap\StructType\Override $item
     * @return \SabreSoap\StructType\Carrier
     */
    public function addToOverride(\SabreSoap\StructType\Override $item)
    {
        $this->Override[] = $item;
        return $this;
    }
    /**
     * Get OnlineIndicator value
     * @return bool|null
     */
    public function getOnlineIndicator()
    {
        return $this->OnlineIndicator;
    }
    /**
     * Set OnlineIndicator value
     * @param bool $onlineIndicator
     * @return \SabreSoap\StructType\Carrier
     */
    public function setOnlineIndicator($onlineIndicator = false)
    {
        $this->OnlineIndicator = $onlineIndicator;
        return $this;
    }
}
