<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for To StructType
 * @subpackage Structs
 */
class To extends AbstractStructBase
{
    /**
     * The PartyId
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: tns:PartyId
     * @var \SabreSoap\StructType\PartyId[]
     */
    public $PartyId;
    /**
     * The Role
     * Meta information extracted from the WSDL
     * - base: string
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $Role;
    /**
     * Constructor method for To
     * @uses To::setPartyId()
     * @uses To::setRole()
     * @param \SabreSoap\StructType\PartyId[] $partyId
     * @param string $role
     */
    public function __construct(array $partyId = array(), $role = null)
    {
        $this
            ->setPartyId($partyId)
            ->setRole($role);
    }
    /**
     * Get PartyId value
     * @return \SabreSoap\StructType\PartyId[]|null
     */
    public function getPartyId()
    {
        return $this->PartyId;
    }
    /**
     * Set PartyId value
     * @param \SabreSoap\StructType\PartyId[] $partyId
     * @return \SabreSoap\StructType\To
     */
    public function setPartyId(array $partyId = array())
    {
        $this->PartyId = $partyId;
        return $this;
    }
    /**
     * Add item to PartyId value
     * @throws \InvalidArgumentException
     * @param \SabreSoap\StructType\PartyId $item
     * @return \SabreSoap\StructType\To
     */
    public function addToPartyId(\SabreSoap\StructType\PartyId $item)
    {
        $this->PartyId[] = $item;
        return $this;
    }
    /**
     * Get Role value
     * @return string|null
     */
    public function getRole()
    {
        return $this->Role;
    }
    /**
     * Set Role value
     * @param string $role
     * @return \SabreSoap\StructType\To
     */
    public function setRole($role = null)
    {
        $this->Role = $role;
        return $this;
    }
}
