<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SummaryPriceInformation StructType
 * @subpackage Structs
 */
class SummaryPriceInformation extends AbstractStructBase
{
    /**
     * The BaseFare
     * Meta information extracted from the WSDL
     * - documentation: Price of the inventory excluding taxes and fees.
     * @var \SabreSoap\StructType\CurrencyAmountType
     */
    public $BaseFare;
    /**
     * The EquivFare
     * Meta information extracted from the WSDL
     * - documentation: Price of the inventory excluding taxes and fees in the payable currency.
     * - minOccurs: 0
     * @var \SabreSoap\StructType\CurrencyAmountType
     */
    public $EquivFare;
    /**
     * The Taxes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\Taxes
     */
    public $Taxes;
    /**
     * The TotalFare
     * Meta information extracted from the WSDL
     * - documentation: The total price that the passenger would pay (includes fare, taxes, fees)
     * @var \SabreSoap\StructType\CurrencyAmountType
     */
    public $TotalFare;
    /**
     * The TotalMileage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\TotalMileage
     */
    public $TotalMileage;
    /**
     * The Segment
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \SabreSoap\StructType\Segment[]
     */
    public $Segment;
    /**
     * Constructor method for SummaryPriceInformation
     * @uses SummaryPriceInformation::setBaseFare()
     * @uses SummaryPriceInformation::setEquivFare()
     * @uses SummaryPriceInformation::setTaxes()
     * @uses SummaryPriceInformation::setTotalFare()
     * @uses SummaryPriceInformation::setTotalMileage()
     * @uses SummaryPriceInformation::setSegment()
     * @param \SabreSoap\StructType\CurrencyAmountType $baseFare
     * @param \SabreSoap\StructType\CurrencyAmountType $equivFare
     * @param \SabreSoap\StructType\Taxes $taxes
     * @param \SabreSoap\StructType\CurrencyAmountType $totalFare
     * @param \SabreSoap\StructType\TotalMileage $totalMileage
     * @param \SabreSoap\StructType\Segment[] $segment
     */
    public function __construct(\SabreSoap\StructType\CurrencyAmountType $baseFare = null, \SabreSoap\StructType\CurrencyAmountType $equivFare = null, \SabreSoap\StructType\Taxes $taxes = null, \SabreSoap\StructType\CurrencyAmountType $totalFare = null, \SabreSoap\StructType\TotalMileage $totalMileage = null, array $segment = array())
    {
        $this
            ->setBaseFare($baseFare)
            ->setEquivFare($equivFare)
            ->setTaxes($taxes)
            ->setTotalFare($totalFare)
            ->setTotalMileage($totalMileage)
            ->setSegment($segment);
    }
    /**
     * Get BaseFare value
     * @return \SabreSoap\StructType\CurrencyAmountType|null
     */
    public function getBaseFare()
    {
        return $this->BaseFare;
    }
    /**
     * Set BaseFare value
     * @param \SabreSoap\StructType\CurrencyAmountType $baseFare
     * @return \SabreSoap\StructType\SummaryPriceInformation
     */
    public function setBaseFare(\SabreSoap\StructType\CurrencyAmountType $baseFare = null)
    {
        $this->BaseFare = $baseFare;
        return $this;
    }
    /**
     * Get EquivFare value
     * @return \SabreSoap\StructType\CurrencyAmountType|null
     */
    public function getEquivFare()
    {
        return $this->EquivFare;
    }
    /**
     * Set EquivFare value
     * @param \SabreSoap\StructType\CurrencyAmountType $equivFare
     * @return \SabreSoap\StructType\SummaryPriceInformation
     */
    public function setEquivFare(\SabreSoap\StructType\CurrencyAmountType $equivFare = null)
    {
        $this->EquivFare = $equivFare;
        return $this;
    }
    /**
     * Get Taxes value
     * @return \SabreSoap\StructType\Taxes|null
     */
    public function getTaxes()
    {
        return $this->Taxes;
    }
    /**
     * Set Taxes value
     * @param \SabreSoap\StructType\Taxes $taxes
     * @return \SabreSoap\StructType\SummaryPriceInformation
     */
    public function setTaxes(\SabreSoap\StructType\Taxes $taxes = null)
    {
        $this->Taxes = $taxes;
        return $this;
    }
    /**
     * Get TotalFare value
     * @return \SabreSoap\StructType\CurrencyAmountType|null
     */
    public function getTotalFare()
    {
        return $this->TotalFare;
    }
    /**
     * Set TotalFare value
     * @param \SabreSoap\StructType\CurrencyAmountType $totalFare
     * @return \SabreSoap\StructType\SummaryPriceInformation
     */
    public function setTotalFare(\SabreSoap\StructType\CurrencyAmountType $totalFare = null)
    {
        $this->TotalFare = $totalFare;
        return $this;
    }
    /**
     * Get TotalMileage value
     * @return \SabreSoap\StructType\TotalMileage|null
     */
    public function getTotalMileage()
    {
        return $this->TotalMileage;
    }
    /**
     * Set TotalMileage value
     * @param \SabreSoap\StructType\TotalMileage $totalMileage
     * @return \SabreSoap\StructType\SummaryPriceInformation
     */
    public function setTotalMileage(\SabreSoap\StructType\TotalMileage $totalMileage = null)
    {
        $this->TotalMileage = $totalMileage;
        return $this;
    }
    /**
     * Get Segment value
     * @return \SabreSoap\StructType\Segment[]|null
     */
    public function getSegment()
    {
        return $this->Segment;
    }
    /**
     * Set Segment value
     * @param \SabreSoap\StructType\Segment[] $segment
     * @return \SabreSoap\StructType\SummaryPriceInformation
     */
    public function setSegment(array $segment = array())
    {
        $this->Segment = $segment;
        return $this;
    }
    /**
     * Add item to Segment value
     * @throws \InvalidArgumentException
     * @param \SabreSoap\StructType\Segment $item
     * @return \SabreSoap\StructType\SummaryPriceInformation
     */
    public function addToSegment(\SabreSoap\StructType\Segment $item)
    {
        $this->Segment[] = $item;
        return $this;
    }
}
