<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareType StructType
 * Meta information extracted from the WSDL
 * - documentation: Holds a base fare, tax, total and currency information on a price
 * @subpackage Structs
 */
class FareType extends AbstractStructBase
{
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}
     * - use: required
     * @var string
     */
    public $Code;
    /**
     * The BaseFare
     * Meta information extracted from the WSDL
     * - documentation: Price of the inventory excluding taxes and fees.
     * @var \SabreSoap\StructType\CurrencyAmountType
     */
    public $BaseFare;
    /**
     * The NonRefundableBaseFare
     * Meta information extracted from the WSDL
     * - documentation: Non-refundable base fare amount
     * - minOccurs: 0
     * @var \SabreSoap\StructType\CurrencyAmountType
     */
    public $NonRefundableBaseFare;
    /**
     * The FareConstruction
     * Meta information extracted from the WSDL
     * - documentation: Fare construction total amount.
     * - minOccurs: 0
     * @var \SabreSoap\StructType\CurrencyAmountType
     */
    public $FareConstruction;
    /**
     * The EquivFare
     * Meta information extracted from the WSDL
     * - documentation: Price of the inventory excluding taxes and fees in the payable currency.
     * - minOccurs: 0
     * @var \SabreSoap\StructType\CurrencyAmountType
     */
    public $EquivFare;
    /**
     * The Taxes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\Taxes
     */
    public $Taxes;
    /**
     * The Fees
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\Fees
     */
    public $Fees;
    /**
     * The OBFees
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\OBFees
     */
    public $OBFees;
    /**
     * The RateOfExchange
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\RateOfExchangeType
     */
    public $RateOfExchange;
    /**
     * The CurrencyConversions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\CurrencyConversionsType
     */
    public $CurrencyConversions;
    /**
     * The TotalFare
     * Meta information extracted from the WSDL
     * - documentation: The total price that the passenger would pay (includes fare, taxes, fees)
     * @var \SabreSoap\StructType\CurrencyAmountType
     */
    public $TotalFare;
    /**
     * The ReissueInfoList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\ReissueInfoList
     */
    public $ReissueInfoList;
    /**
     * The PenaltiesInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\PenaltiesInfo
     */
    public $PenaltiesInfo;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\TPA_Extensions
     */
    public $TPA_Extensions;
    /**
     * The NegotiatedFare
     * Meta information extracted from the WSDL
     * - documentation: Indicator to show if this is a private fare.
     * - default: false
     * - type: xs:boolean
     * - use: optional
     * @var bool
     */
    public $NegotiatedFare;
    /**
     * The NegotiatedFareCode
     * Meta information extracted from the WSDL
     * - documentation: Code used to identify the private fare.
     * - type: xs:string
     * - use: optional
     * @var string
     */
    public $NegotiatedFareCode;
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The Name
     * @var string
     */
    public $Name;
    /**
     * Constructor method for FareType
     * @uses FareType::setCode()
     * @uses FareType::setBaseFare()
     * @uses FareType::setNonRefundableBaseFare()
     * @uses FareType::setFareConstruction()
     * @uses FareType::setEquivFare()
     * @uses FareType::setTaxes()
     * @uses FareType::setFees()
     * @uses FareType::setOBFees()
     * @uses FareType::setRateOfExchange()
     * @uses FareType::setCurrencyConversions()
     * @uses FareType::setTotalFare()
     * @uses FareType::setReissueInfoList()
     * @uses FareType::setPenaltiesInfo()
     * @uses FareType::setTPA_Extensions()
     * @uses FareType::setNegotiatedFare()
     * @uses FareType::setNegotiatedFareCode()
     * @uses FareType::set_()
     * @uses FareType::setName()
     * @param string $code
     * @param \SabreSoap\StructType\CurrencyAmountType $baseFare
     * @param \SabreSoap\StructType\CurrencyAmountType $nonRefundableBaseFare
     * @param \SabreSoap\StructType\CurrencyAmountType $fareConstruction
     * @param \SabreSoap\StructType\CurrencyAmountType $equivFare
     * @param \SabreSoap\StructType\Taxes $taxes
     * @param \SabreSoap\StructType\Fees $fees
     * @param \SabreSoap\StructType\OBFees $oBFees
     * @param \SabreSoap\StructType\RateOfExchangeType $rateOfExchange
     * @param \SabreSoap\StructType\CurrencyConversionsType $currencyConversions
     * @param \SabreSoap\StructType\CurrencyAmountType $totalFare
     * @param \SabreSoap\StructType\ReissueInfoList $reissueInfoList
     * @param \SabreSoap\StructType\PenaltiesInfo $penaltiesInfo
     * @param \SabreSoap\StructType\TPA_Extensions $tPA_Extensions
     * @param bool $negotiatedFare
     * @param string $negotiatedFareCode
     * @param string $_
     * @param string $name
     */
    public function __construct($code = null, \SabreSoap\StructType\CurrencyAmountType $baseFare = null, \SabreSoap\StructType\CurrencyAmountType $nonRefundableBaseFare = null, \SabreSoap\StructType\CurrencyAmountType $fareConstruction = null, \SabreSoap\StructType\CurrencyAmountType $equivFare = null, \SabreSoap\StructType\Taxes $taxes = null, \SabreSoap\StructType\Fees $fees = null, \SabreSoap\StructType\OBFees $oBFees = null, \SabreSoap\StructType\RateOfExchangeType $rateOfExchange = null, \SabreSoap\StructType\CurrencyConversionsType $currencyConversions = null, \SabreSoap\StructType\CurrencyAmountType $totalFare = null, \SabreSoap\StructType\ReissueInfoList $reissueInfoList = null, \SabreSoap\StructType\PenaltiesInfo $penaltiesInfo = null, \SabreSoap\StructType\TPA_Extensions $tPA_Extensions = null, $negotiatedFare = false, $negotiatedFareCode = null, $_ = null, $name = null)
    {
        $this
            ->setCode($code)
            ->setBaseFare($baseFare)
            ->setNonRefundableBaseFare($nonRefundableBaseFare)
            ->setFareConstruction($fareConstruction)
            ->setEquivFare($equivFare)
            ->setTaxes($taxes)
            ->setFees($fees)
            ->setOBFees($oBFees)
            ->setRateOfExchange($rateOfExchange)
            ->setCurrencyConversions($currencyConversions)
            ->setTotalFare($totalFare)
            ->setReissueInfoList($reissueInfoList)
            ->setPenaltiesInfo($penaltiesInfo)
            ->setTPA_Extensions($tPA_Extensions)
            ->setNegotiatedFare($negotiatedFare)
            ->setNegotiatedFareCode($negotiatedFareCode)
            ->set_($_)
            ->setName($name);
    }
    /**
     * Get Code value
     * @return string
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \SabreSoap\StructType\FareType
     */
    public function setCode($code = null)
    {
        $this->Code = $code;
        return $this;
    }
    /**
     * Get BaseFare value
     * @return \SabreSoap\StructType\CurrencyAmountType|null
     */
    public function getBaseFare()
    {
        return $this->BaseFare;
    }
    /**
     * Set BaseFare value
     * @param \SabreSoap\StructType\CurrencyAmountType $baseFare
     * @return \SabreSoap\StructType\FareType
     */
    public function setBaseFare(\SabreSoap\StructType\CurrencyAmountType $baseFare = null)
    {
        $this->BaseFare = $baseFare;
        return $this;
    }
    /**
     * Get NonRefundableBaseFare value
     * @return \SabreSoap\StructType\CurrencyAmountType|null
     */
    public function getNonRefundableBaseFare()
    {
        return $this->NonRefundableBaseFare;
    }
    /**
     * Set NonRefundableBaseFare value
     * @param \SabreSoap\StructType\CurrencyAmountType $nonRefundableBaseFare
     * @return \SabreSoap\StructType\FareType
     */
    public function setNonRefundableBaseFare(\SabreSoap\StructType\CurrencyAmountType $nonRefundableBaseFare = null)
    {
        $this->NonRefundableBaseFare = $nonRefundableBaseFare;
        return $this;
    }
    /**
     * Get FareConstruction value
     * @return \SabreSoap\StructType\CurrencyAmountType|null
     */
    public function getFareConstruction()
    {
        return $this->FareConstruction;
    }
    /**
     * Set FareConstruction value
     * @param \SabreSoap\StructType\CurrencyAmountType $fareConstruction
     * @return \SabreSoap\StructType\FareType
     */
    public function setFareConstruction(\SabreSoap\StructType\CurrencyAmountType $fareConstruction = null)
    {
        $this->FareConstruction = $fareConstruction;
        return $this;
    }
    /**
     * Get EquivFare value
     * @return \SabreSoap\StructType\CurrencyAmountType|null
     */
    public function getEquivFare()
    {
        return $this->EquivFare;
    }
    /**
     * Set EquivFare value
     * @param \SabreSoap\StructType\CurrencyAmountType $equivFare
     * @return \SabreSoap\StructType\FareType
     */
    public function setEquivFare(\SabreSoap\StructType\CurrencyAmountType $equivFare = null)
    {
        $this->EquivFare = $equivFare;
        return $this;
    }
    /**
     * Get Taxes value
     * @return \SabreSoap\StructType\Taxes|null
     */
    public function getTaxes()
    {
        return $this->Taxes;
    }
    /**
     * Set Taxes value
     * @param \SabreSoap\StructType\Taxes $taxes
     * @return \SabreSoap\StructType\FareType
     */
    public function setTaxes(\SabreSoap\StructType\Taxes $taxes = null)
    {
        $this->Taxes = $taxes;
        return $this;
    }
    /**
     * Get Fees value
     * @return \SabreSoap\StructType\Fees|null
     */
    public function getFees()
    {
        return $this->Fees;
    }
    /**
     * Set Fees value
     * @param \SabreSoap\StructType\Fees $fees
     * @return \SabreSoap\StructType\FareType
     */
    public function setFees(\SabreSoap\StructType\Fees $fees = null)
    {
        $this->Fees = $fees;
        return $this;
    }
    /**
     * Get OBFees value
     * @return \SabreSoap\StructType\OBFees|null
     */
    public function getOBFees()
    {
        return $this->OBFees;
    }
    /**
     * Set OBFees value
     * @param \SabreSoap\StructType\OBFees $oBFees
     * @return \SabreSoap\StructType\FareType
     */
    public function setOBFees(\SabreSoap\StructType\OBFees $oBFees = null)
    {
        $this->OBFees = $oBFees;
        return $this;
    }
    /**
     * Get RateOfExchange value
     * @return \SabreSoap\StructType\RateOfExchangeType|null
     */
    public function getRateOfExchange()
    {
        return $this->RateOfExchange;
    }
    /**
     * Set RateOfExchange value
     * @param \SabreSoap\StructType\RateOfExchangeType $rateOfExchange
     * @return \SabreSoap\StructType\FareType
     */
    public function setRateOfExchange(\SabreSoap\StructType\RateOfExchangeType $rateOfExchange = null)
    {
        $this->RateOfExchange = $rateOfExchange;
        return $this;
    }
    /**
     * Get CurrencyConversions value
     * @return \SabreSoap\StructType\CurrencyConversionsType|null
     */
    public function getCurrencyConversions()
    {
        return $this->CurrencyConversions;
    }
    /**
     * Set CurrencyConversions value
     * @param \SabreSoap\StructType\CurrencyConversionsType $currencyConversions
     * @return \SabreSoap\StructType\FareType
     */
    public function setCurrencyConversions(\SabreSoap\StructType\CurrencyConversionsType $currencyConversions = null)
    {
        $this->CurrencyConversions = $currencyConversions;
        return $this;
    }
    /**
     * Get TotalFare value
     * @return \SabreSoap\StructType\CurrencyAmountType|null
     */
    public function getTotalFare()
    {
        return $this->TotalFare;
    }
    /**
     * Set TotalFare value
     * @param \SabreSoap\StructType\CurrencyAmountType $totalFare
     * @return \SabreSoap\StructType\FareType
     */
    public function setTotalFare(\SabreSoap\StructType\CurrencyAmountType $totalFare = null)
    {
        $this->TotalFare = $totalFare;
        return $this;
    }
    /**
     * Get ReissueInfoList value
     * @return \SabreSoap\StructType\ReissueInfoList|null
     */
    public function getReissueInfoList()
    {
        return $this->ReissueInfoList;
    }
    /**
     * Set ReissueInfoList value
     * @param \SabreSoap\StructType\ReissueInfoList $reissueInfoList
     * @return \SabreSoap\StructType\FareType
     */
    public function setReissueInfoList(\SabreSoap\StructType\ReissueInfoList $reissueInfoList = null)
    {
        $this->ReissueInfoList = $reissueInfoList;
        return $this;
    }
    /**
     * Get PenaltiesInfo value
     * @return \SabreSoap\StructType\PenaltiesInfo|null
     */
    public function getPenaltiesInfo()
    {
        return $this->PenaltiesInfo;
    }
    /**
     * Set PenaltiesInfo value
     * @param \SabreSoap\StructType\PenaltiesInfo $penaltiesInfo
     * @return \SabreSoap\StructType\FareType
     */
    public function setPenaltiesInfo(\SabreSoap\StructType\PenaltiesInfo $penaltiesInfo = null)
    {
        $this->PenaltiesInfo = $penaltiesInfo;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \SabreSoap\StructType\TPA_Extensions|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \SabreSoap\StructType\TPA_Extensions $tPA_Extensions
     * @return \SabreSoap\StructType\FareType
     */
    public function setTPA_Extensions(\SabreSoap\StructType\TPA_Extensions $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get NegotiatedFare value
     * @return bool|null
     */
    public function getNegotiatedFare()
    {
        return $this->NegotiatedFare;
    }
    /**
     * Set NegotiatedFare value
     * @param bool $negotiatedFare
     * @return \SabreSoap\StructType\FareType
     */
    public function setNegotiatedFare($negotiatedFare = false)
    {
        $this->NegotiatedFare = $negotiatedFare;
        return $this;
    }
    /**
     * Get NegotiatedFareCode value
     * @return string|null
     */
    public function getNegotiatedFareCode()
    {
        return $this->NegotiatedFareCode;
    }
    /**
     * Set NegotiatedFareCode value
     * @param string $negotiatedFareCode
     * @return \SabreSoap\StructType\FareType
     */
    public function setNegotiatedFareCode($negotiatedFareCode = null)
    {
        $this->NegotiatedFareCode = $negotiatedFareCode;
        return $this;
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \SabreSoap\StructType\FareType
     */
    public function set_($_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \SabreSoap\StructType\FareType
     */
    public function setName($name = null)
    {
        $this->Name = $name;
        return $this;
    }
}
