<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CompanyNameType StructType
 * Meta information extracted from the WSDL
 * - documentation: Identifies a company by name.
 * @subpackage Structs
 */
class CompanyNameType extends AbstractStructBase
{
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The CompanyShortName
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 64
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - type: StringLength1to64
     * - use: optional
     * @var string
     */
    public $CompanyShortName;
    /**
     * The TravelSector
     * Meta information extracted from the WSDL
     * - documentation: Refer to OTA Code List Travel Sector (TVS). | Used for codes in the OTA code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - type: OTA_CodeType
     * - use: optional
     * @var string
     */
    public $TravelSector;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - documentation: Identifies a company by the company code. | Used for Character Strings, length 1 to 8
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * - type: StringLength1to8
     * - use: optional
     * @var string
     */
    public $Code;
    /**
     * The CodeContext
     * Meta information extracted from the WSDL
     * - documentation: Identifies the context of the identifying code, such as DUNS, IATA or internal code, etc. | Used for Character Strings, length 1 to 32
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - type: StringLength1to32
     * - use: optional
     * @var string
     */
    public $CodeContext;
    /**
     * Constructor method for CompanyNameType
     * @uses CompanyNameType::set_()
     * @uses CompanyNameType::setCompanyShortName()
     * @uses CompanyNameType::setTravelSector()
     * @uses CompanyNameType::setCode()
     * @uses CompanyNameType::setCodeContext()
     * @param string $_
     * @param string $companyShortName
     * @param string $travelSector
     * @param string $code
     * @param string $codeContext
     */
    public function __construct($_ = null, $companyShortName = null, $travelSector = null, $code = null, $codeContext = null)
    {
        $this
            ->set_($_)
            ->setCompanyShortName($companyShortName)
            ->setTravelSector($travelSector)
            ->setCode($code)
            ->setCodeContext($codeContext);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \SabreSoap\StructType\CompanyNameType
     */
    public function set_($_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Get CompanyShortName value
     * @return string|null
     */
    public function getCompanyShortName()
    {
        return $this->CompanyShortName;
    }
    /**
     * Set CompanyShortName value
     * @param string $companyShortName
     * @return \SabreSoap\StructType\CompanyNameType
     */
    public function setCompanyShortName($companyShortName = null)
    {
        $this->CompanyShortName = $companyShortName;
        return $this;
    }
    /**
     * Get TravelSector value
     * @return string|null
     */
    public function getTravelSector()
    {
        return $this->TravelSector;
    }
    /**
     * Set TravelSector value
     * @param string $travelSector
     * @return \SabreSoap\StructType\CompanyNameType
     */
    public function setTravelSector($travelSector = null)
    {
        $this->TravelSector = $travelSector;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \SabreSoap\StructType\CompanyNameType
     */
    public function setCode($code = null)
    {
        $this->Code = $code;
        return $this;
    }
    /**
     * Get CodeContext value
     * @return string|null
     */
    public function getCodeContext()
    {
        return $this->CodeContext;
    }
    /**
     * Set CodeContext value
     * @param string $codeContext
     * @return \SabreSoap\StructType\CompanyNameType
     */
    public function setCodeContext($codeContext = null)
    {
        $this->CodeContext = $codeContext;
        return $this;
    }
}
