<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BillingInformationType StructType
 * @subpackage Structs
 */
class BillingInformationType extends AbstractStructBase
{
    /**
     * The UserStation
     * Meta information extracted from the WSDL
     * - default: 0
     * - use: optional
     * @var int
     */
    public $UserStation;
    /**
     * The UserBranch
     * Meta information extracted from the WSDL
     * - default: 0
     * - use: optional
     * @var int
     */
    public $UserBranch;
    /**
     * The PartitionID
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - pattern: [0-9A-Z]{2,4}
     * - use: optional
     * @var string
     */
    public $PartitionID;
    /**
     * The UserSetAddress
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - pattern: [0-9A-F]{6}
     * - use: optional
     * @var string
     */
    public $UserSetAddress;
    /**
     * The AAACity
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 16
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $AAACity;
    /**
     * The AgentSineIn
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 3
     * - use: optional
     * @var string
     */
    public $AgentSineIn;
    /**
     * The ServiceName
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - pattern: [0-9a-zA-Z,]{1,8}
     * - use: optional
     * @var string
     */
    public $ServiceName;
    /**
     * The ActionCode
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 5
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $ActionCode;
    /**
     * Constructor method for BillingInformationType
     * @uses BillingInformationType::setUserStation()
     * @uses BillingInformationType::setUserBranch()
     * @uses BillingInformationType::setPartitionID()
     * @uses BillingInformationType::setUserSetAddress()
     * @uses BillingInformationType::setAAACity()
     * @uses BillingInformationType::setAgentSineIn()
     * @uses BillingInformationType::setServiceName()
     * @uses BillingInformationType::setActionCode()
     * @param int $userStation
     * @param int $userBranch
     * @param string $partitionID
     * @param string $userSetAddress
     * @param string $aAACity
     * @param string $agentSineIn
     * @param string $serviceName
     * @param string $actionCode
     */
    public function __construct($userStation = 0, $userBranch = 0, $partitionID = null, $userSetAddress = null, $aAACity = null, $agentSineIn = null, $serviceName = null, $actionCode = null)
    {
        $this
            ->setUserStation($userStation)
            ->setUserBranch($userBranch)
            ->setPartitionID($partitionID)
            ->setUserSetAddress($userSetAddress)
            ->setAAACity($aAACity)
            ->setAgentSineIn($agentSineIn)
            ->setServiceName($serviceName)
            ->setActionCode($actionCode);
    }
    /**
     * Get UserStation value
     * @return int|null
     */
    public function getUserStation()
    {
        return $this->UserStation;
    }
    /**
     * Set UserStation value
     * @param int $userStation
     * @return \SabreSoap\StructType\BillingInformationType
     */
    public function setUserStation($userStation = 0)
    {
        $this->UserStation = $userStation;
        return $this;
    }
    /**
     * Get UserBranch value
     * @return int|null
     */
    public function getUserBranch()
    {
        return $this->UserBranch;
    }
    /**
     * Set UserBranch value
     * @param int $userBranch
     * @return \SabreSoap\StructType\BillingInformationType
     */
    public function setUserBranch($userBranch = 0)
    {
        $this->UserBranch = $userBranch;
        return $this;
    }
    /**
     * Get PartitionID value
     * @return string|null
     */
    public function getPartitionID()
    {
        return $this->PartitionID;
    }
    /**
     * Set PartitionID value
     * @param string $partitionID
     * @return \SabreSoap\StructType\BillingInformationType
     */
    public function setPartitionID($partitionID = null)
    {
        $this->PartitionID = $partitionID;
        return $this;
    }
    /**
     * Get UserSetAddress value
     * @return string|null
     */
    public function getUserSetAddress()
    {
        return $this->UserSetAddress;
    }
    /**
     * Set UserSetAddress value
     * @param string $userSetAddress
     * @return \SabreSoap\StructType\BillingInformationType
     */
    public function setUserSetAddress($userSetAddress = null)
    {
        $this->UserSetAddress = $userSetAddress;
        return $this;
    }
    /**
     * Get AAACity value
     * @return string|null
     */
    public function getAAACity()
    {
        return $this->AAACity;
    }
    /**
     * Set AAACity value
     * @param string $aAACity
     * @return \SabreSoap\StructType\BillingInformationType
     */
    public function setAAACity($aAACity = null)
    {
        $this->AAACity = $aAACity;
        return $this;
    }
    /**
     * Get AgentSineIn value
     * @return string|null
     */
    public function getAgentSineIn()
    {
        return $this->AgentSineIn;
    }
    /**
     * Set AgentSineIn value
     * @param string $agentSineIn
     * @return \SabreSoap\StructType\BillingInformationType
     */
    public function setAgentSineIn($agentSineIn = null)
    {
        $this->AgentSineIn = $agentSineIn;
        return $this;
    }
    /**
     * Get ServiceName value
     * @return string|null
     */
    public function getServiceName()
    {
        return $this->ServiceName;
    }
    /**
     * Set ServiceName value
     * @param string $serviceName
     * @return \SabreSoap\StructType\BillingInformationType
     */
    public function setServiceName($serviceName = null)
    {
        $this->ServiceName = $serviceName;
        return $this;
    }
    /**
     * Get ActionCode value
     * @return string|null
     */
    public function getActionCode()
    {
        return $this->ActionCode;
    }
    /**
     * Set ActionCode value
     * @param string $actionCode
     * @return \SabreSoap\StructType\BillingInformationType
     */
    public function setActionCode($actionCode = null)
    {
        $this->ActionCode = $actionCode;
        return $this;
    }
}
