<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddressType StructType
 * @subpackage Structs
 */
class AddressType extends AbstractStructBase
{
    /**
     * The StreetNmbr
     * Meta information extracted from the WSDL
     * - documentation: Street Name and Number within the address
     * - minOccurs: 0
     * @var \SabreSoap\StructType\StreetNmbrType
     */
    public $StreetNmbr;
    /**
     * The BldgRoom
     * Meta information extracted from the WSDL
     * - documentation: Building name, room, apartment, or suite number. | Used for Character Strings, length 0 to 64
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $BldgRoom;
    /**
     * The AddressLine
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 64
     * - base: xs:string
     * - maxLength: 64
     * - maxOccurs: 5
     * - minLength: 1
     * - minOccurs: 0
     * @var string[]
     */
    public $AddressLine;
    /**
     * The CityName
     * Meta information extracted from the WSDL
     * - documentation: City name eg. Dublin | Used for Character Strings, length 1 to 64
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $CityName;
    /**
     * The PostalCode
     * Meta information extracted from the WSDL
     * - documentation: Post Office Code number. | Used for Character Strings, length 1 to 16
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $PostalCode;
    /**
     * The County
     * Meta information extracted from the WSDL
     * - documentation: County Name eg. Fairfax | Used for Character Strings, length 1 to 32
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $County;
    /**
     * The StateProv
     * Meta information extracted from the WSDL
     * - documentation: State name eg. Texas
     * - minOccurs: 0
     * @var \SabreSoap\StructType\StateProvType
     */
    public $StateProv;
    /**
     * The CountryName
     * Meta information extracted from the WSDL
     * - documentation: Country name eg. Ireland
     * - minOccurs: 0
     * @var \SabreSoap\StructType\CountryNameType
     */
    public $CountryName;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - documentation: Defines the type of address (e.g. home, business, other). Refer to OTA Code List Communication Location Type (CLT). | Used for codes in the OTA code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - use: optional
     * @var string
     */
    public $Type;
    /**
     * The FormattedInd
     * Meta information extracted from the WSDL
     * - documentation: Specifies if the associated data is formatted or not. If true, then it is formatted, if false, then not formatted.
     * - default: false
     * - type: xs:boolean
     * - use: optional
     * @var bool
     */
    public $FormattedInd;
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * Constructor method for AddressType
     * @uses AddressType::setStreetNmbr()
     * @uses AddressType::setBldgRoom()
     * @uses AddressType::setAddressLine()
     * @uses AddressType::setCityName()
     * @uses AddressType::setPostalCode()
     * @uses AddressType::setCounty()
     * @uses AddressType::setStateProv()
     * @uses AddressType::setCountryName()
     * @uses AddressType::setType()
     * @uses AddressType::setFormattedInd()
     * @uses AddressType::setShareSynchInd()
     * @uses AddressType::setShareMarketInd()
     * @param \SabreSoap\StructType\StreetNmbrType $streetNmbr
     * @param string $bldgRoom
     * @param string[] $addressLine
     * @param string $cityName
     * @param string $postalCode
     * @param string $county
     * @param \SabreSoap\StructType\StateProvType $stateProv
     * @param \SabreSoap\StructType\CountryNameType $countryName
     * @param string $type
     * @param bool $formattedInd
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     */
    public function __construct(\SabreSoap\StructType\StreetNmbrType $streetNmbr = null, $bldgRoom = null, array $addressLine = array(), $cityName = null, $postalCode = null, $county = null, \SabreSoap\StructType\StateProvType $stateProv = null, \SabreSoap\StructType\CountryNameType $countryName = null, $type = null, $formattedInd = false, $shareSynchInd = null, $shareMarketInd = null)
    {
        $this
            ->setStreetNmbr($streetNmbr)
            ->setBldgRoom($bldgRoom)
            ->setAddressLine($addressLine)
            ->setCityName($cityName)
            ->setPostalCode($postalCode)
            ->setCounty($county)
            ->setStateProv($stateProv)
            ->setCountryName($countryName)
            ->setType($type)
            ->setFormattedInd($formattedInd)
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd);
    }
    /**
     * Get StreetNmbr value
     * @return \SabreSoap\StructType\StreetNmbrType|null
     */
    public function getStreetNmbr()
    {
        return $this->StreetNmbr;
    }
    /**
     * Set StreetNmbr value
     * @param \SabreSoap\StructType\StreetNmbrType $streetNmbr
     * @return \SabreSoap\StructType\AddressType
     */
    public function setStreetNmbr(\SabreSoap\StructType\StreetNmbrType $streetNmbr = null)
    {
        $this->StreetNmbr = $streetNmbr;
        return $this;
    }
    /**
     * Get BldgRoom value
     * @return string|null
     */
    public function getBldgRoom()
    {
        return $this->BldgRoom;
    }
    /**
     * Set BldgRoom value
     * @param string $bldgRoom
     * @return \SabreSoap\StructType\AddressType
     */
    public function setBldgRoom($bldgRoom = null)
    {
        $this->BldgRoom = $bldgRoom;
        return $this;
    }
    /**
     * Get AddressLine value
     * @return string[]|null
     */
    public function getAddressLine()
    {
        return $this->AddressLine;
    }
    /**
     * Set AddressLine value
     * @param string[] $addressLine
     * @return \SabreSoap\StructType\AddressType
     */
    public function setAddressLine(array $addressLine = array())
    {
        $this->AddressLine = $addressLine;
        return $this;
    }
    /**
     * Add item to AddressLine value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \SabreSoap\StructType\AddressType
     */
    public function addToAddressLine($item)
    {
        $this->AddressLine[] = $item;
        return $this;
    }
    /**
     * Get CityName value
     * @return string|null
     */
    public function getCityName()
    {
        return $this->CityName;
    }
    /**
     * Set CityName value
     * @param string $cityName
     * @return \SabreSoap\StructType\AddressType
     */
    public function setCityName($cityName = null)
    {
        $this->CityName = $cityName;
        return $this;
    }
    /**
     * Get PostalCode value
     * @return string|null
     */
    public function getPostalCode()
    {
        return $this->PostalCode;
    }
    /**
     * Set PostalCode value
     * @param string $postalCode
     * @return \SabreSoap\StructType\AddressType
     */
    public function setPostalCode($postalCode = null)
    {
        $this->PostalCode = $postalCode;
        return $this;
    }
    /**
     * Get County value
     * @return string|null
     */
    public function getCounty()
    {
        return $this->County;
    }
    /**
     * Set County value
     * @param string $county
     * @return \SabreSoap\StructType\AddressType
     */
    public function setCounty($county = null)
    {
        $this->County = $county;
        return $this;
    }
    /**
     * Get StateProv value
     * @return \SabreSoap\StructType\StateProvType|null
     */
    public function getStateProv()
    {
        return $this->StateProv;
    }
    /**
     * Set StateProv value
     * @param \SabreSoap\StructType\StateProvType $stateProv
     * @return \SabreSoap\StructType\AddressType
     */
    public function setStateProv(\SabreSoap\StructType\StateProvType $stateProv = null)
    {
        $this->StateProv = $stateProv;
        return $this;
    }
    /**
     * Get CountryName value
     * @return \SabreSoap\StructType\CountryNameType|null
     */
    public function getCountryName()
    {
        return $this->CountryName;
    }
    /**
     * Set CountryName value
     * @param \SabreSoap\StructType\CountryNameType $countryName
     * @return \SabreSoap\StructType\AddressType
     */
    public function setCountryName(\SabreSoap\StructType\CountryNameType $countryName = null)
    {
        $this->CountryName = $countryName;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \SabreSoap\StructType\AddressType
     */
    public function setType($type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get FormattedInd value
     * @return bool|null
     */
    public function getFormattedInd()
    {
        return $this->FormattedInd;
    }
    /**
     * Set FormattedInd value
     * @param bool $formattedInd
     * @return \SabreSoap\StructType\AddressType
     */
    public function setFormattedInd($formattedInd = false)
    {
        $this->FormattedInd = $formattedInd;
        return $this;
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \SabreSoap\StructType\AddressType
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \SabreSoap\StructType\AddressType
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
}
