<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VoluntaryChangesType StructType
 * Meta information extracted from the WSDL
 * - documentation: Specifies charges and/or penalties associated with making ticket changes after purchase.
 * @subpackage Structs
 */
class VoluntaryChangesType extends AbstractStructBase
{
    /**
     * The Penalty
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\Penalty
     */
    public $Penalty;
    /**
     * The VolChangeInd
     * Meta information extracted from the WSDL
     * - documentation: Indicator used to specify whether voluntary change and other penalties are involved in the search or response.
     * - use: optional
     * @var bool
     */
    public $VolChangeInd;
    /**
     * Constructor method for VoluntaryChangesType
     * @uses VoluntaryChangesType::setPenalty()
     * @uses VoluntaryChangesType::setVolChangeInd()
     * @param \SabreSoap\StructType\Penalty $penalty
     * @param bool $volChangeInd
     */
    public function __construct(\SabreSoap\StructType\Penalty $penalty = null, $volChangeInd = null)
    {
        $this
            ->setPenalty($penalty)
            ->setVolChangeInd($volChangeInd);
    }
    /**
     * Get Penalty value
     * @return \SabreSoap\StructType\Penalty|null
     */
    public function getPenalty()
    {
        return $this->Penalty;
    }
    /**
     * Set Penalty value
     * @param \SabreSoap\StructType\Penalty $penalty
     * @return \SabreSoap\StructType\VoluntaryChangesType
     */
    public function setPenalty(\SabreSoap\StructType\Penalty $penalty = null)
    {
        $this->Penalty = $penalty;
        return $this;
    }
    /**
     * Get VolChangeInd value
     * @return bool|null
     */
    public function getVolChangeInd()
    {
        return $this->VolChangeInd;
    }
    /**
     * Set VolChangeInd value
     * @param bool $volChangeInd
     * @return \SabreSoap\StructType\VoluntaryChangesType
     */
    public function setVolChangeInd($volChangeInd = null)
    {
        $this->VolChangeInd = $volChangeInd;
        return $this;
    }
}
