<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValidatingCarrierInfoType StructType
 * @subpackage Structs
 */
class ValidatingCarrierInfoType extends AbstractStructBase
{
    /**
     * The Default
     * Meta information extracted from the WSDL
     * - documentation: Default validating carrier code
     * - base: xs:string
     * - minOccurs: 0
     * - pattern: [A-Za-z]{0}
     * @var string
     */
    public $Default;
    /**
     * The Alternate
     * Meta information extracted from the WSDL
     * - documentation: Alternate validating carrier code
     * - base: xs:string
     * - maxOccurs: 24
     * - minOccurs: 0
     * - pattern: [0-9A-Z]{2,3}
     * @var string[]
     */
    public $Alternate;
    /**
     * The SettlementMethod
     * Meta information extracted from the WSDL
     * - documentation: Used for Strings, length exactly 3
     * - base: xs:string
     * - maxLength: 3
     * - minLength: 3
     * @var string
     */
    public $SettlementMethod;
    /**
     * The NewVcxProcess
     * @var bool
     */
    public $NewVcxProcess;
    /**
     * Constructor method for ValidatingCarrierInfoType
     * @uses ValidatingCarrierInfoType::setDefault()
     * @uses ValidatingCarrierInfoType::setAlternate()
     * @uses ValidatingCarrierInfoType::setSettlementMethod()
     * @uses ValidatingCarrierInfoType::setNewVcxProcess()
     * @param string $default
     * @param string[] $alternate
     * @param string $settlementMethod
     * @param bool $newVcxProcess
     */
    public function __construct($default = null, array $alternate = array(), $settlementMethod = null, $newVcxProcess = null)
    {
        $this
            ->setDefault($default)
            ->setAlternate($alternate)
            ->setSettlementMethod($settlementMethod)
            ->setNewVcxProcess($newVcxProcess);
    }
    /**
     * Get Default value
     * @return string|null
     */
    public function getDefault()
    {
        return $this->Default;
    }
    /**
     * Set Default value
     * @param string $default
     * @return \SabreSoap\StructType\ValidatingCarrierInfoType
     */
    public function setDefault($default = null)
    {
        $this->Default = $default;
        return $this;
    }
    /**
     * Get Alternate value
     * @return string[]|null
     */
    public function getAlternate()
    {
        return $this->Alternate;
    }
    /**
     * Set Alternate value
     * @param string[] $alternate
     * @return \SabreSoap\StructType\ValidatingCarrierInfoType
     */
    public function setAlternate(array $alternate = array())
    {
        $this->Alternate = $alternate;
        return $this;
    }
    /**
     * Add item to Alternate value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \SabreSoap\StructType\ValidatingCarrierInfoType
     */
    public function addToAlternate($item)
    {
        $this->Alternate[] = $item;
        return $this;
    }
    /**
     * Get SettlementMethod value
     * @return string|null
     */
    public function getSettlementMethod()
    {
        return $this->SettlementMethod;
    }
    /**
     * Set SettlementMethod value
     * @param string $settlementMethod
     * @return \SabreSoap\StructType\ValidatingCarrierInfoType
     */
    public function setSettlementMethod($settlementMethod = null)
    {
        $this->SettlementMethod = $settlementMethod;
        return $this;
    }
    /**
     * Get NewVcxProcess value
     * @return bool|null
     */
    public function getNewVcxProcess()
    {
        return $this->NewVcxProcess;
    }
    /**
     * Set NewVcxProcess value
     * @param bool $newVcxProcess
     * @return \SabreSoap\StructType\ValidatingCarrierInfoType
     */
    public function setNewVcxProcess($newVcxProcess = null)
    {
        $this->NewVcxProcess = $newVcxProcess;
        return $this;
    }
}
