<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TimeOfDayDistribution StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines how the options in the response should be distributed between certain departure time of day ranges. All defined TimeOfDayRanges need to cover the whole day and the sum of all Percentages needs to equal 100.
 * @subpackage Structs
 */
class TimeOfDayDistribution extends AbstractStructBase
{
    /**
     * The TimeOfDayRange
     * Meta information extracted from the WSDL
     * - maxOccurs: 4
     * - minOccurs: 2
     * @var \SabreSoap\StructType\TimeOfDayRange[]
     */
    public $TimeOfDayRange;
    /**
     * Constructor method for TimeOfDayDistribution
     * @uses TimeOfDayDistribution::setTimeOfDayRange()
     * @param \SabreSoap\StructType\TimeOfDayRange[] $timeOfDayRange
     */
    public function __construct(array $timeOfDayRange = array())
    {
        $this
            ->setTimeOfDayRange($timeOfDayRange);
    }
    /**
     * Get TimeOfDayRange value
     * @return \SabreSoap\StructType\TimeOfDayRange[]
     */
    public function getTimeOfDayRange()
    {
        return $this->TimeOfDayRange;
    }
    /**
     * Set TimeOfDayRange value
     * @param \SabreSoap\StructType\TimeOfDayRange[] $timeOfDayRange
     * @return \SabreSoap\StructType\TimeOfDayDistribution
     */
    public function setTimeOfDayRange(array $timeOfDayRange = array())
    {
        $this->TimeOfDayRange = $timeOfDayRange;
        return $this;
    }
    /**
     * Add item to TimeOfDayRange value
     * @throws \InvalidArgumentException
     * @param \SabreSoap\StructType\TimeOfDayRange $item
     * @return \SabreSoap\StructType\TimeOfDayDistribution
     */
    public function addToTimeOfDayRange(\SabreSoap\StructType\TimeOfDayRange $item)
    {
        $this->TimeOfDayRange[] = $item;
        return $this;
    }
}
