<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaxCodeType StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines the data fields available for tax code.
 * @subpackage Structs
 */
class TaxCodeType extends AbstractStructBase
{
    /**
     * The TaxCode
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - pattern: [A-Z0-9]{2}[A-Z0-9]{0,1}
     * - use: required
     * @var string
     */
    public $TaxCode;
    /**
     * Constructor method for TaxCodeType
     * @uses TaxCodeType::setTaxCode()
     * @param string $taxCode
     */
    public function __construct($taxCode = null)
    {
        $this
            ->setTaxCode($taxCode);
    }
    /**
     * Get TaxCode value
     * @return string
     */
    public function getTaxCode()
    {
        return $this->TaxCode;
    }
    /**
     * Set TaxCode value
     * @param string $taxCode
     * @return \SabreSoap\StructType\TaxCodeType
     */
    public function setTaxCode($taxCode = null)
    {
        $this->TaxCode = $taxCode;
        return $this;
    }
}
