<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StateProvType StructType
 * Meta information extracted from the WSDL
 * - documentation: State, province, or region name or code needed to identify location. | Used for Character Strings, length 0 to 64
 * - base: xs:string
 * - maxLength: 64
 * - minLength: 0
 * @subpackage Structs
 */
class StateProvType extends AbstractStructBase
{
    /**
     * The _
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 0 to 64
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 0
     * @var string
     */
    public $_;
    /**
     * The StateCode
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 8
     * - base: StringLength1to8
     * - maxLength: 8
     * - minLength: 2
     * @var string
     */
    public $StateCode;
    /**
     * Constructor method for StateProvType
     * @uses StateProvType::set_()
     * @uses StateProvType::setStateCode()
     * @param string $_
     * @param string $stateCode
     */
    public function __construct($_ = null, $stateCode = null)
    {
        $this
            ->set_($_)
            ->setStateCode($stateCode);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \SabreSoap\StructType\StateProvType
     */
    public function set_($_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Get StateCode value
     * @return string|null
     */
    public function getStateCode()
    {
        return $this->StateCode;
    }
    /**
     * Set StateCode value
     * @param string $stateCode
     * @return \SabreSoap\StructType\StateProvType
     */
    public function setStateCode($stateCode = null)
    {
        $this->StateCode = $stateCode;
        return $this;
    }
}
