<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SignatureType StructType
 * @subpackage Structs
 */
class SignatureType extends AbstractStructBase
{
    /**
     * The SignedInfo
     * Meta information extracted from the WSDL
     * - ref: ds:SignedInfo
     * @var \SabreSoap\StructType\SignedInfoType
     */
    public $SignedInfo;
    /**
     * The SignatureValue
     * Meta information extracted from the WSDL
     * - ref: ds:SignatureValue
     * @var \SabreSoap\StructType\SignatureValueType
     */
    public $SignatureValue;
    /**
     * The KeyInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: ds:KeyInfo
     * @var \SabreSoap\StructType\KeyInfoType
     */
    public $KeyInfo;
    /**
     * The Object
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Object
     * @var \SabreSoap\StructType\ObjectType[]
     */
    public $Object;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Id;
    /**
     * Constructor method for SignatureType
     * @uses SignatureType::setSignedInfo()
     * @uses SignatureType::setSignatureValue()
     * @uses SignatureType::setKeyInfo()
     * @uses SignatureType::setObject()
     * @uses SignatureType::setId()
     * @param \SabreSoap\StructType\SignedInfoType $signedInfo
     * @param \SabreSoap\StructType\SignatureValueType $signatureValue
     * @param \SabreSoap\StructType\KeyInfoType $keyInfo
     * @param \SabreSoap\StructType\ObjectType[] $object
     * @param string $id
     */
    public function __construct(\SabreSoap\StructType\SignedInfoType $signedInfo = null, \SabreSoap\StructType\SignatureValueType $signatureValue = null, \SabreSoap\StructType\KeyInfoType $keyInfo = null, array $object = array(), $id = null)
    {
        $this
            ->setSignedInfo($signedInfo)
            ->setSignatureValue($signatureValue)
            ->setKeyInfo($keyInfo)
            ->setObject($object)
            ->setId($id);
    }
    /**
     * Get SignedInfo value
     * @return \SabreSoap\StructType\SignedInfoType|null
     */
    public function getSignedInfo()
    {
        return $this->SignedInfo;
    }
    /**
     * Set SignedInfo value
     * @param \SabreSoap\StructType\SignedInfoType $signedInfo
     * @return \SabreSoap\StructType\SignatureType
     */
    public function setSignedInfo(\SabreSoap\StructType\SignedInfoType $signedInfo = null)
    {
        $this->SignedInfo = $signedInfo;
        return $this;
    }
    /**
     * Get SignatureValue value
     * @return \SabreSoap\StructType\SignatureValueType|null
     */
    public function getSignatureValue()
    {
        return $this->SignatureValue;
    }
    /**
     * Set SignatureValue value
     * @param \SabreSoap\StructType\SignatureValueType $signatureValue
     * @return \SabreSoap\StructType\SignatureType
     */
    public function setSignatureValue(\SabreSoap\StructType\SignatureValueType $signatureValue = null)
    {
        $this->SignatureValue = $signatureValue;
        return $this;
    }
    /**
     * Get KeyInfo value
     * @return \SabreSoap\StructType\KeyInfoType|null
     */
    public function getKeyInfo()
    {
        return $this->KeyInfo;
    }
    /**
     * Set KeyInfo value
     * @param \SabreSoap\StructType\KeyInfoType $keyInfo
     * @return \SabreSoap\StructType\SignatureType
     */
    public function setKeyInfo(\SabreSoap\StructType\KeyInfoType $keyInfo = null)
    {
        $this->KeyInfo = $keyInfo;
        return $this;
    }
    /**
     * Get Object value
     * @return \SabreSoap\StructType\ObjectType[]|null
     */
    public function getObject()
    {
        return $this->Object;
    }
    /**
     * Set Object value
     * @param \SabreSoap\StructType\ObjectType[] $object
     * @return \SabreSoap\StructType\SignatureType
     */
    public function setObject(array $object = array())
    {
        $this->Object = $object;
        return $this;
    }
    /**
     * Add item to Object value
     * @throws \InvalidArgumentException
     * @param \SabreSoap\StructType\ObjectType $item
     * @return \SabreSoap\StructType\SignatureType
     */
    public function addToObject(\SabreSoap\StructType\ObjectType $item)
    {
        $this->Object[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \SabreSoap\StructType\SignatureType
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
}
