<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Schema StructType
 * @subpackage Structs
 */
class Schema extends AbstractStructBase
{
    /**
     * The location
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $location;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - base: string
     * - minLength: 1
     * @var string
     */
    public $version;
    /**
     * Constructor method for Schema
     * @uses Schema::setLocation()
     * @uses Schema::setVersion()
     * @param string $location
     * @param string $version
     */
    public function __construct($location = null, $version = null)
    {
        $this
            ->setLocation($location)
            ->setVersion($version);
    }
    /**
     * Get location value
     * @return string
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param string $location
     * @return \SabreSoap\StructType\Schema
     */
    public function setLocation($location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \SabreSoap\StructType\Schema
     */
    public function setVersion($version = null)
    {
        $this->version = $version;
        return $this;
    }
}
