<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReservationType StructType
 * @subpackage Structs
 */
class ReservationType extends AbstractStructBase
{
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - documentation: Reservation status
     * - base: xs:string
     * - pattern: [A-Z]{1,2}
     * - use: optional
     * @var string
     */
    public $Status;
    /**
     * The RealStatus
     * Meta information extracted from the WSDL
     * - documentation: Real reservation status
     * - base: xs:string
     * - pattern: [A-Z]{1,2}
     * - use: optional
     * @var string
     */
    public $RealStatus;
    /**
     * Constructor method for ReservationType
     * @uses ReservationType::setStatus()
     * @uses ReservationType::setRealStatus()
     * @param string $status
     * @param string $realStatus
     */
    public function __construct($status = null, $realStatus = null)
    {
        $this
            ->setStatus($status)
            ->setRealStatus($realStatus);
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \SabreSoap\StructType\ReservationType
     */
    public function setStatus($status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get RealStatus value
     * @return string|null
     */
    public function getRealStatus()
    {
        return $this->RealStatus;
    }
    /**
     * Set RealStatus value
     * @param string $realStatus
     * @return \SabreSoap\StructType\ReservationType
     */
    public function setRealStatus($realStatus = null)
    {
        $this->RealStatus = $realStatus;
        return $this;
    }
}
