<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PromoOffer StructType
 * Meta information extracted from the WSDL
 * - documentation: Promotional offer
 * @subpackage Structs
 */
class PromoOffer extends AbstractStructBase
{
    /**
     * The PromoID
     * Meta information extracted from the WSDL
     * - documentation: Promotional offer identifier
     * @var string
     */
    public $PromoID;
    /**
     * The CorpID
     * Meta information extracted from the WSDL
     * - documentation: Airline identifier.
     * - use: optional
     * @var string
     */
    public $CorpID;
    /**
     * The ContentID
     * Meta information extracted from the WSDL
     * - documentation: This information comes from Fare Notes Rule fired and is taken by Travelocity to look up detailed data on their database to put on the website.
     * @var string
     */
    public $ContentID;
    /**
     * Constructor method for PromoOffer
     * @uses PromoOffer::setPromoID()
     * @uses PromoOffer::setCorpID()
     * @uses PromoOffer::setContentID()
     * @param string $promoID
     * @param string $corpID
     * @param string $contentID
     */
    public function __construct($promoID = null, $corpID = null, $contentID = null)
    {
        $this
            ->setPromoID($promoID)
            ->setCorpID($corpID)
            ->setContentID($contentID);
    }
    /**
     * Get PromoID value
     * @return string|null
     */
    public function getPromoID()
    {
        return $this->PromoID;
    }
    /**
     * Set PromoID value
     * @param string $promoID
     * @return \SabreSoap\StructType\PromoOffer
     */
    public function setPromoID($promoID = null)
    {
        $this->PromoID = $promoID;
        return $this;
    }
    /**
     * Get CorpID value
     * @return string|null
     */
    public function getCorpID()
    {
        return $this->CorpID;
    }
    /**
     * Set CorpID value
     * @param string $corpID
     * @return \SabreSoap\StructType\PromoOffer
     */
    public function setCorpID($corpID = null)
    {
        $this->CorpID = $corpID;
        return $this;
    }
    /**
     * Get ContentID value
     * @return string|null
     */
    public function getContentID()
    {
        return $this->ContentID;
    }
    /**
     * Set ContentID value
     * @param string $contentID
     * @return \SabreSoap\StructType\PromoOffer
     */
    public function setContentID($contentID = null)
    {
        $this->ContentID = $contentID;
        return $this;
    }
}
