<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OriginDestinationInformationType StructType
 * Meta information extracted from the WSDL
 * - documentation: Origin and Destination location, and time information for the request. Also includes the ability to specify a connection location for the search.
 * @subpackage Structs
 */
class OriginDestinationInformationType extends TravelDateTimeType
{
    /**
     * The OriginLocation
     * @var \SabreSoap\StructType\OriginLocation
     */
    public $OriginLocation;
    /**
     * The DestinationLocation
     * @var \SabreSoap\StructType\DestinationLocation
     */
    public $DestinationLocation;
    /**
     * The ConnectionLocations
     * Meta information extracted from the WSDL
     * - documentation: Travel Connection Location - for example, air uses the IATA 3 letter code.
     * - minOccurs: 0
     * @var \SabreSoap\StructType\ConnectionType
     */
    public $ConnectionLocations;
    /**
     * Constructor method for OriginDestinationInformationType
     * @uses OriginDestinationInformationType::setOriginLocation()
     * @uses OriginDestinationInformationType::setDestinationLocation()
     * @uses OriginDestinationInformationType::setConnectionLocations()
     * @param \SabreSoap\StructType\OriginLocation $originLocation
     * @param \SabreSoap\StructType\DestinationLocation $destinationLocation
     * @param \SabreSoap\StructType\ConnectionType $connectionLocations
     */
    public function __construct(\SabreSoap\StructType\OriginLocation $originLocation = null, \SabreSoap\StructType\DestinationLocation $destinationLocation = null, \SabreSoap\StructType\ConnectionType $connectionLocations = null)
    {
        $this
            ->setOriginLocation($originLocation)
            ->setDestinationLocation($destinationLocation)
            ->setConnectionLocations($connectionLocations);
    }
    /**
     * Get OriginLocation value
     * @return \SabreSoap\StructType\OriginLocation|null
     */
    public function getOriginLocation()
    {
        return $this->OriginLocation;
    }
    /**
     * Set OriginLocation value
     * @param \SabreSoap\StructType\OriginLocation $originLocation
     * @return \SabreSoap\StructType\OriginDestinationInformationType
     */
    public function setOriginLocation(\SabreSoap\StructType\OriginLocation $originLocation = null)
    {
        $this->OriginLocation = $originLocation;
        return $this;
    }
    /**
     * Get DestinationLocation value
     * @return \SabreSoap\StructType\DestinationLocation|null
     */
    public function getDestinationLocation()
    {
        return $this->DestinationLocation;
    }
    /**
     * Set DestinationLocation value
     * @param \SabreSoap\StructType\DestinationLocation $destinationLocation
     * @return \SabreSoap\StructType\OriginDestinationInformationType
     */
    public function setDestinationLocation(\SabreSoap\StructType\DestinationLocation $destinationLocation = null)
    {
        $this->DestinationLocation = $destinationLocation;
        return $this;
    }
    /**
     * Get ConnectionLocations value
     * @return \SabreSoap\StructType\ConnectionType|null
     */
    public function getConnectionLocations()
    {
        return $this->ConnectionLocations;
    }
    /**
     * Set ConnectionLocations value
     * @param \SabreSoap\StructType\ConnectionType $connectionLocations
     * @return \SabreSoap\StructType\OriginDestinationInformationType
     */
    public function setConnectionLocations(\SabreSoap\StructType\ConnectionType $connectionLocations = null)
    {
        $this->ConnectionLocations = $connectionLocations;
        return $this;
    }
}
