<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MinimumStay StructType
 * Meta information extracted from the WSDL
 * - documentation: Specifies restrictions for the shortest length/period of time or earliest day return travel can commence or be completed.
 * @subpackage Structs
 */
class MinimumStay extends AbstractStructBase
{
    /**
     * The ReturnTimeOfDay
     * Meta information extracted from the WSDL
     * - documentation: The time of day when return travel may commence. | Allows for the specification of a date time or just time.
     * - union: string | time
     * - use: optional
     * @var string
     */
    public $ReturnTimeOfDay;
    /**
     * The MinStay
     * Meta information extracted from the WSDL
     * - documentation: The amount of elapsed time or number of occurrences of a day of the week needed to satisfy a minimum stay requirement. | Used for Numeric values, from 1 to 99 inclusive
     * - base: xs:integer
     * - maxInclusive: 99
     * - minInclusive: 1
     * - use: optional
     * @var int
     */
    public $MinStay;
    /**
     * The StayUnit
     * Meta information extracted from the WSDL
     * - documentation: The unit of elapsed time or the day of the week applied to the MinStay value.
     * - use: optional
     * @var string
     */
    public $StayUnit;
    /**
     * The MinStayDate
     * Meta information extracted from the WSDL
     * - documentation: The specific date for the minimum stay requirement. | Allows for the specification of a date time or just time.
     * - union: string | time
     * - use: optional
     * @var string
     */
    public $MinStayDate;
    /**
     * Constructor method for MinimumStay
     * @uses MinimumStay::setReturnTimeOfDay()
     * @uses MinimumStay::setMinStay()
     * @uses MinimumStay::setStayUnit()
     * @uses MinimumStay::setMinStayDate()
     * @param string $returnTimeOfDay
     * @param int $minStay
     * @param string $stayUnit
     * @param string $minStayDate
     */
    public function __construct($returnTimeOfDay = null, $minStay = null, $stayUnit = null, $minStayDate = null)
    {
        $this
            ->setReturnTimeOfDay($returnTimeOfDay)
            ->setMinStay($minStay)
            ->setStayUnit($stayUnit)
            ->setMinStayDate($minStayDate);
    }
    /**
     * Get ReturnTimeOfDay value
     * @return string|null
     */
    public function getReturnTimeOfDay()
    {
        return $this->ReturnTimeOfDay;
    }
    /**
     * Set ReturnTimeOfDay value
     * @param string $returnTimeOfDay
     * @return \SabreSoap\StructType\MinimumStay
     */
    public function setReturnTimeOfDay($returnTimeOfDay = null)
    {
        $this->ReturnTimeOfDay = $returnTimeOfDay;
        return $this;
    }
    /**
     * Get MinStay value
     * @return int|null
     */
    public function getMinStay()
    {
        return $this->MinStay;
    }
    /**
     * Set MinStay value
     * @param int $minStay
     * @return \SabreSoap\StructType\MinimumStay
     */
    public function setMinStay($minStay = null)
    {
        $this->MinStay = $minStay;
        return $this;
    }
    /**
     * Get StayUnit value
     * @return string|null
     */
    public function getStayUnit()
    {
        return $this->StayUnit;
    }
    /**
     * Set StayUnit value
     * @param string $stayUnit
     * @return \SabreSoap\StructType\MinimumStay
     */
    public function setStayUnit($stayUnit = null)
    {
        $this->StayUnit = $stayUnit;
        return $this;
    }
    /**
     * Get MinStayDate value
     * @return string|null
     */
    public function getMinStayDate()
    {
        return $this->MinStayDate;
    }
    /**
     * Set MinStayDate value
     * @param string $minStayDate
     * @return \SabreSoap\StructType\MinimumStay
     */
    public function setMinStayDate($minStayDate = null)
    {
        $this->MinStayDate = $minStayDate;
        return $this;
    }
}
