<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KeyInfoType StructType
 * Meta information extracted from the WSDL
 * - mixed: true
 * @subpackage Structs
 */
class KeyInfoType extends AbstractStructBase
{
    /**
     * The KeyName
     * Meta information extracted from the WSDL
     * - choice: KeyName | KeyValue | RetrievalMethod | X509Data | PGPData | SPKIData | MgmtData |
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 1
     * - ref: ds:KeyName
     * @var string
     */
    public $KeyName;
    /**
     * The KeyValue
     * Meta information extracted from the WSDL
     * - choice: KeyName | KeyValue | RetrievalMethod | X509Data | PGPData | SPKIData | MgmtData |
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 1
     * - ref: ds:KeyValue
     * @var \SabreSoap\StructType\KeyValueType
     */
    public $KeyValue;
    /**
     * The RetrievalMethod
     * Meta information extracted from the WSDL
     * - choice: KeyName | KeyValue | RetrievalMethod | X509Data | PGPData | SPKIData | MgmtData |
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 1
     * - ref: ds:RetrievalMethod
     * @var \SabreSoap\StructType\RetrievalMethodType
     */
    public $RetrievalMethod;
    /**
     * The X509Data
     * Meta information extracted from the WSDL
     * - choice: KeyName | KeyValue | RetrievalMethod | X509Data | PGPData | SPKIData | MgmtData |
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 1
     * - ref: ds:X509Data
     * @var \SabreSoap\StructType\X509DataType
     */
    public $X509Data;
    /**
     * The PGPData
     * Meta information extracted from the WSDL
     * - choice: KeyName | KeyValue | RetrievalMethod | X509Data | PGPData | SPKIData | MgmtData |
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 1
     * - ref: ds:PGPData
     * @var \SabreSoap\StructType\PGPDataType
     */
    public $PGPData;
    /**
     * The SPKIData
     * Meta information extracted from the WSDL
     * - choice: KeyName | KeyValue | RetrievalMethod | X509Data | PGPData | SPKIData | MgmtData |
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 1
     * - ref: ds:SPKIData
     * @var \SabreSoap\StructType\SPKIDataType
     */
    public $SPKIData;
    /**
     * The MgmtData
     * Meta information extracted from the WSDL
     * - choice: KeyName | KeyValue | RetrievalMethod | X509Data | PGPData | SPKIData | MgmtData |
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 1
     * - ref: ds:MgmtData
     * @var string
     */
    public $MgmtData;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Id;
    /**
     * Constructor method for KeyInfoType
     * @uses KeyInfoType::setKeyName()
     * @uses KeyInfoType::setKeyValue()
     * @uses KeyInfoType::setRetrievalMethod()
     * @uses KeyInfoType::setX509Data()
     * @uses KeyInfoType::setPGPData()
     * @uses KeyInfoType::setSPKIData()
     * @uses KeyInfoType::setMgmtData()
     * @uses KeyInfoType::setAny()
     * @uses KeyInfoType::setId()
     * @param string $keyName
     * @param \SabreSoap\StructType\KeyValueType $keyValue
     * @param \SabreSoap\StructType\RetrievalMethodType $retrievalMethod
     * @param \SabreSoap\StructType\X509DataType $x509Data
     * @param \SabreSoap\StructType\PGPDataType $pGPData
     * @param \SabreSoap\StructType\SPKIDataType $sPKIData
     * @param string $mgmtData
     * @param \DOMDocument $any
     * @param string $id
     */
    public function __construct($keyName = null, \SabreSoap\StructType\KeyValueType $keyValue = null, \SabreSoap\StructType\RetrievalMethodType $retrievalMethod = null, \SabreSoap\StructType\X509DataType $x509Data = null, \SabreSoap\StructType\PGPDataType $pGPData = null, \SabreSoap\StructType\SPKIDataType $sPKIData = null, $mgmtData = null, \DOMDocument $any = null, $id = null)
    {
        $this
            ->setKeyName($keyName)
            ->setKeyValue($keyValue)
            ->setRetrievalMethod($retrievalMethod)
            ->setX509Data($x509Data)
            ->setPGPData($pGPData)
            ->setSPKIData($sPKIData)
            ->setMgmtData($mgmtData)
            ->setAny($any)
            ->setId($id);
    }
    /**
     * Get KeyName value
     * @return string|null
     */
    public function getKeyName()
    {
        return isset($this->KeyName) ? $this->KeyName : null;
    }
    /**
     * Set KeyName value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $keyName
     * @return \SabreSoap\StructType\KeyInfoType
     */
    public function setKeyName($keyName = null)
    {
        if (is_null($keyName) || (is_array($keyName) && empty($keyName))) {
            unset($this->KeyName);
        } else {
            $this->KeyName = $keyName;
        }
        return $this;
    }
    /**
     * Get KeyValue value
     * @return \SabreSoap\StructType\KeyValueType|null
     */
    public function getKeyValue()
    {
        return isset($this->KeyValue) ? $this->KeyValue : null;
    }
    /**
     * Set KeyValue value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param \SabreSoap\StructType\KeyValueType $keyValue
     * @return \SabreSoap\StructType\KeyInfoType
     */
    public function setKeyValue(\SabreSoap\StructType\KeyValueType $keyValue = null)
    {
        if (is_null($keyValue) || (is_array($keyValue) && empty($keyValue))) {
            unset($this->KeyValue);
        } else {
            $this->KeyValue = $keyValue;
        }
        return $this;
    }
    /**
     * Get RetrievalMethod value
     * @return \SabreSoap\StructType\RetrievalMethodType|null
     */
    public function getRetrievalMethod()
    {
        return isset($this->RetrievalMethod) ? $this->RetrievalMethod : null;
    }
    /**
     * Set RetrievalMethod value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param \SabreSoap\StructType\RetrievalMethodType $retrievalMethod
     * @return \SabreSoap\StructType\KeyInfoType
     */
    public function setRetrievalMethod(\SabreSoap\StructType\RetrievalMethodType $retrievalMethod = null)
    {
        if (is_null($retrievalMethod) || (is_array($retrievalMethod) && empty($retrievalMethod))) {
            unset($this->RetrievalMethod);
        } else {
            $this->RetrievalMethod = $retrievalMethod;
        }
        return $this;
    }
    /**
     * Get X509Data value
     * @return \SabreSoap\StructType\X509DataType|null
     */
    public function getX509Data()
    {
        return isset($this->X509Data) ? $this->X509Data : null;
    }
    /**
     * Set X509Data value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param \SabreSoap\StructType\X509DataType $x509Data
     * @return \SabreSoap\StructType\KeyInfoType
     */
    public function setX509Data(\SabreSoap\StructType\X509DataType $x509Data = null)
    {
        if (is_null($x509Data) || (is_array($x509Data) && empty($x509Data))) {
            unset($this->X509Data);
        } else {
            $this->X509Data = $x509Data;
        }
        return $this;
    }
    /**
     * Get PGPData value
     * @return \SabreSoap\StructType\PGPDataType|null
     */
    public function getPGPData()
    {
        return isset($this->PGPData) ? $this->PGPData : null;
    }
    /**
     * Set PGPData value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param \SabreSoap\StructType\PGPDataType $pGPData
     * @return \SabreSoap\StructType\KeyInfoType
     */
    public function setPGPData(\SabreSoap\StructType\PGPDataType $pGPData = null)
    {
        if (is_null($pGPData) || (is_array($pGPData) && empty($pGPData))) {
            unset($this->PGPData);
        } else {
            $this->PGPData = $pGPData;
        }
        return $this;
    }
    /**
     * Get SPKIData value
     * @return \SabreSoap\StructType\SPKIDataType|null
     */
    public function getSPKIData()
    {
        return isset($this->SPKIData) ? $this->SPKIData : null;
    }
    /**
     * Set SPKIData value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param \SabreSoap\StructType\SPKIDataType $sPKIData
     * @return \SabreSoap\StructType\KeyInfoType
     */
    public function setSPKIData(\SabreSoap\StructType\SPKIDataType $sPKIData = null)
    {
        if (is_null($sPKIData) || (is_array($sPKIData) && empty($sPKIData))) {
            unset($this->SPKIData);
        } else {
            $this->SPKIData = $sPKIData;
        }
        return $this;
    }
    /**
     * Get MgmtData value
     * @return string|null
     */
    public function getMgmtData()
    {
        return isset($this->MgmtData) ? $this->MgmtData : null;
    }
    /**
     * Set MgmtData value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $mgmtData
     * @return \SabreSoap\StructType\KeyInfoType
     */
    public function setMgmtData($mgmtData = null)
    {
        if (is_null($mgmtData) || (is_array($mgmtData) && empty($mgmtData))) {
            unset($this->MgmtData);
        } else {
            $this->MgmtData = $mgmtData;
        }
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \SabreSoap\StructType\KeyInfoType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \SabreSoap\StructType\KeyInfoType
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
}
