<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Fault StructType
 * Meta information extracted from the WSDL
 * - documentation: Fault reporting structure
 * - final: extension
 * - type: tns:Fault
 * @subpackage Structs
 */
class Fault extends AbstractStructBase
{
    /**
     * The faultcode
     * @var string
     */
    public $faultcode;
    /**
     * The faultstring
     * @var string
     */
    public $faultstring;
    /**
     * The faultactor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $faultactor;
    /**
     * The detail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\Detail
     */
    public $detail;
    /**
     * Constructor method for Fault
     * @uses Fault::setFaultcode()
     * @uses Fault::setFaultstring()
     * @uses Fault::setFaultactor()
     * @uses Fault::setDetail()
     * @param string $faultcode
     * @param string $faultstring
     * @param string $faultactor
     * @param \SabreSoap\StructType\Detail $detail
     */
    public function __construct($faultcode = null, $faultstring = null, $faultactor = null, \SabreSoap\StructType\Detail $detail = null)
    {
        $this
            ->setFaultcode($faultcode)
            ->setFaultstring($faultstring)
            ->setFaultactor($faultactor)
            ->setDetail($detail);
    }
    /**
     * Get faultcode value
     * @return string|null
     */
    public function getFaultcode()
    {
        return $this->faultcode;
    }
    /**
     * Set faultcode value
     * @param string $faultcode
     * @return \SabreSoap\StructType\Fault
     */
    public function setFaultcode($faultcode = null)
    {
        $this->faultcode = $faultcode;
        return $this;
    }
    /**
     * Get faultstring value
     * @return string|null
     */
    public function getFaultstring()
    {
        return $this->faultstring;
    }
    /**
     * Set faultstring value
     * @param string $faultstring
     * @return \SabreSoap\StructType\Fault
     */
    public function setFaultstring($faultstring = null)
    {
        $this->faultstring = $faultstring;
        return $this;
    }
    /**
     * Get faultactor value
     * @return string|null
     */
    public function getFaultactor()
    {
        return $this->faultactor;
    }
    /**
     * Set faultactor value
     * @param string $faultactor
     * @return \SabreSoap\StructType\Fault
     */
    public function setFaultactor($faultactor = null)
    {
        $this->faultactor = $faultactor;
        return $this;
    }
    /**
     * Get detail value
     * @return \SabreSoap\StructType\Detail|null
     */
    public function getDetail()
    {
        return $this->detail;
    }
    /**
     * Set detail value
     * @param \SabreSoap\StructType\Detail $detail
     * @return \SabreSoap\StructType\Fault
     */
    public function setDetail(\SabreSoap\StructType\Detail $detail = null)
    {
        $this->detail = $detail;
        return $this;
    }
}
