<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DaysRange StructType
 * @subpackage Structs
 */
class DaysRange extends AbstractStructBase
{
    /**
     * The FromDate
     * Meta information extracted from the WSDL
     * - documentation: IntelliSell Date type (required format: YYYY-MM-DD)
     * - base: xs:string
     * - pattern: [0-9]{4}-[0-9]{2}-[0-9]{2}
     * - use: required
     * @var string
     */
    public $FromDate;
    /**
     * The ToDate
     * Meta information extracted from the WSDL
     * - documentation: IntelliSell Date type (required format: YYYY-MM-DD)
     * - base: xs:string
     * - pattern: [0-9]{4}-[0-9]{2}-[0-9]{2}
     * - use: required
     * @var string
     */
    public $ToDate;
    /**
     * The WeekDays
     * Meta information extracted from the WSDL
     * - documentation: Value format: First letter of the name of the day or '_', eg. 'SMT___S' means we are interested in departing at Saturday, Sunday, Monday or Tuesday. Even if there are schedules for Wednesday, Thursday or Friday, they won't be
     * returned in ISell response.
     * - base: xs:string
     * - pattern: [S_][M_][T_][W_][T_][F_][S_]
     * @var string
     */
    public $WeekDays;
    /**
     * Constructor method for DaysRange
     * @uses DaysRange::setFromDate()
     * @uses DaysRange::setToDate()
     * @uses DaysRange::setWeekDays()
     * @param string $fromDate
     * @param string $toDate
     * @param string $weekDays
     */
    public function __construct($fromDate = null, $toDate = null, $weekDays = null)
    {
        $this
            ->setFromDate($fromDate)
            ->setToDate($toDate)
            ->setWeekDays($weekDays);
    }
    /**
     * Get FromDate value
     * @return string
     */
    public function getFromDate()
    {
        return $this->FromDate;
    }
    /**
     * Set FromDate value
     * @param string $fromDate
     * @return \SabreSoap\StructType\DaysRange
     */
    public function setFromDate($fromDate = null)
    {
        $this->FromDate = $fromDate;
        return $this;
    }
    /**
     * Get ToDate value
     * @return string
     */
    public function getToDate()
    {
        return $this->ToDate;
    }
    /**
     * Set ToDate value
     * @param string $toDate
     * @return \SabreSoap\StructType\DaysRange
     */
    public function setToDate($toDate = null)
    {
        $this->ToDate = $toDate;
        return $this;
    }
    /**
     * Get WeekDays value
     * @return string|null
     */
    public function getWeekDays()
    {
        return $this->WeekDays;
    }
    /**
     * Set WeekDays value
     * @param string $weekDays
     * @return \SabreSoap\StructType\DaysRange
     */
    public function setWeekDays($weekDays = null)
    {
        $this->WeekDays = $weekDays;
        return $this;
    }
}
