<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DateFlexibility StructType
 * Meta information extracted from the WSDL
 * - documentation: The number of alternate days around the travel date to search.
 * - maxOccurs: 2
 * - minOccurs: 0
 * @subpackage Structs
 */
class DateFlexibility extends AbstractStructBase
{
    /**
     * The NbrOfDays
     * Meta information extracted from the WSDL
     * - documentation: Number of alternate dates before and after requested travel date.
     * - use: optional
     * @var int
     */
    public $NbrOfDays;
    /**
     * The Plus
     * Meta information extracted from the WSDL
     * - documentation: Number of alternate dates before requested travel date.
     * - use: optional
     * @var int
     */
    public $Plus;
    /**
     * The Minus
     * Meta information extracted from the WSDL
     * - documentation: Number of alternate dates after requested travel date.
     * - use: optional
     * @var int
     */
    public $Minus;
    /**
     * The Validate
     * Meta information extracted from the WSDL
     * - documentation: Flag telling if dates within the specified range should be processed in the validate path.
     * - use: optional
     * @var bool
     */
    public $Validate;
    /**
     * Constructor method for DateFlexibility
     * @uses DateFlexibility::setNbrOfDays()
     * @uses DateFlexibility::setPlus()
     * @uses DateFlexibility::setMinus()
     * @uses DateFlexibility::setValidate()
     * @param int $nbrOfDays
     * @param int $plus
     * @param int $minus
     * @param bool $validate
     */
    public function __construct($nbrOfDays = null, $plus = null, $minus = null, $validate = null)
    {
        $this
            ->setNbrOfDays($nbrOfDays)
            ->setPlus($plus)
            ->setMinus($minus)
            ->setValidate($validate);
    }
    /**
     * Get NbrOfDays value
     * @return int|null
     */
    public function getNbrOfDays()
    {
        return $this->NbrOfDays;
    }
    /**
     * Set NbrOfDays value
     * @param int $nbrOfDays
     * @return \SabreSoap\StructType\DateFlexibility
     */
    public function setNbrOfDays($nbrOfDays = null)
    {
        $this->NbrOfDays = $nbrOfDays;
        return $this;
    }
    /**
     * Get Plus value
     * @return int|null
     */
    public function getPlus()
    {
        return $this->Plus;
    }
    /**
     * Set Plus value
     * @param int $plus
     * @return \SabreSoap\StructType\DateFlexibility
     */
    public function setPlus($plus = null)
    {
        $this->Plus = $plus;
        return $this;
    }
    /**
     * Get Minus value
     * @return int|null
     */
    public function getMinus()
    {
        return $this->Minus;
    }
    /**
     * Set Minus value
     * @param int $minus
     * @return \SabreSoap\StructType\DateFlexibility
     */
    public function setMinus($minus = null)
    {
        $this->Minus = $minus;
        return $this;
    }
    /**
     * Get Validate value
     * @return bool|null
     */
    public function getValidate()
    {
        return $this->Validate;
    }
    /**
     * Set Validate value
     * @param bool $validate
     * @return \SabreSoap\StructType\DateFlexibility
     */
    public function setValidate($validate = null)
    {
        $this->Validate = $validate;
        return $this;
    }
}
