<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CabinPrefType StructType
 * Meta information extracted from the WSDL
 * - documentation: Indicates preferences for choice of airline cabin for a given travel situation.
 * @subpackage Structs
 */
class CabinPrefType extends AbstractStructBase
{
    /**
     * The Cabin
     * Meta information extracted from the WSDL
     * - documentation: Specify cabin type.
     * @var string
     */
    public $Cabin;
    /**
     * The PreferLevel
     * Meta information extracted from the WSDL
     * - default: Preferred
     * - type: PreferLevelType
     * @var string
     */
    public $PreferLevel;
    /**
     * Constructor method for CabinPrefType
     * @uses CabinPrefType::setCabin()
     * @uses CabinPrefType::setPreferLevel()
     * @param string $cabin
     * @param string $preferLevel
     */
    public function __construct($cabin = null, $preferLevel = 'Preferred')
    {
        $this
            ->setCabin($cabin)
            ->setPreferLevel($preferLevel);
    }
    /**
     * Get Cabin value
     * @return string|null
     */
    public function getCabin()
    {
        return $this->Cabin;
    }
    /**
     * Set Cabin value
     * @param string $cabin
     * @return \SabreSoap\StructType\CabinPrefType
     */
    public function setCabin($cabin = null)
    {
        $this->Cabin = $cabin;
        return $this;
    }
    /**
     * Get PreferLevel value
     * @return string|null
     */
    public function getPreferLevel()
    {
        return $this->PreferLevel;
    }
    /**
     * Set PreferLevel value
     * @param string $preferLevel
     * @return \SabreSoap\StructType\CabinPrefType
     */
    public function setPreferLevel($preferLevel = 'Preferred')
    {
        $this->PreferLevel = $preferLevel;
        return $this;
    }
}
