<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BookFlightSegmentType StructType
 * Meta information extracted from the WSDL
 * - documentation: Container for the flight segment data plus the MarriageGrp.
 * @subpackage Structs
 */
class BookFlightSegmentType extends AbstractStructBase
{
    /**
     * The DepartureDateTime
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $DepartureDateTime;
    /**
     * The DepartureAirport
     * Meta information extracted from the WSDL
     * - documentation: Departure point of flight segment.
     * @var \SabreSoap\StructType\AirportInformationType
     */
    public $DepartureAirport;
    /**
     * The ArrivalAirport
     * Meta information extracted from the WSDL
     * - documentation: Arrival point of flight segment.
     * @var \SabreSoap\StructType\AirportInformationType
     */
    public $ArrivalAirport;
    /**
     * The OperatingAirline
     * Meta information extracted from the WSDL
     * - documentation: The operating airline of the flight if it is a codeshare flight.
     * - minOccurs: 0
     * @var \SabreSoap\StructType\OperatingAirlineType
     */
    public $OperatingAirline;
    /**
     * The Equipment
     * Meta information extracted from the WSDL
     * - documentation: The type of equipment used for the flight..
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var \SabreSoap\StructType\EquipmentType[]
     */
    public $Equipment;
    /**
     * The MarketingAirline
     * Meta information extracted from the WSDL
     * - documentation: The marketing airline. This is required for use with scheduled airline messages but may be omitted for requests by tour operators.
     * - minOccurs: 0
     * @var \SabreSoap\StructType\CompanyNameType
     */
    public $MarketingAirline;
    /**
     * The DisclosureAirline
     * Meta information extracted from the WSDL
     * - documentation: The disclosure airline. This is required by the DOT mandate.
     * - minOccurs: 0
     * @var \SabreSoap\StructType\CompanyNameType
     */
    public $DisclosureAirline;
    /**
     * The MarriageGrp
     * Meta information extracted from the WSDL
     * - documentation: Many airlines link connection flights together by terming them married segments. When two or more segments are married, they must be processed as one unit. The segments must be moved, cancelled, and/or priced together. The value of
     * the marriage group must be the same for all segments. | Used for Character Strings, length 1 to 16
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $MarriageGrp;
    /**
     * The StopAirports
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\StopAirports
     */
    public $StopAirports;
    /**
     * The DepartureTimeZone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\DepartureTimeZone
     */
    public $DepartureTimeZone;
    /**
     * The ArrivalTimeZone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\ArrivalTimeZone
     */
    public $ArrivalTimeZone;
    /**
     * The OnTimePerformance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\OnTimePerformance
     */
    public $OnTimePerformance;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\TPA_Extensions
     */
    public $TPA_Extensions;
    /**
     * The ArrivalDateTime
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ArrivalDateTime;
    /**
     * The StopQuantity
     * Meta information extracted from the WSDL
     * - documentation: The number of stops the flight makes
     * - use: optional
     * @var int
     */
    public $StopQuantity;
    /**
     * The RPH
     * Meta information extracted from the WSDL
     * - documentation: (Reference Place Holder) - an index code to identify an instance in a collection of like items.. For example, used to assign individual passengers or clients to particular itinerary items.
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * @var string
     */
    public $RPH;
    /**
     * The InfoSource
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 32
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $InfoSource;
    /**
     * The FlightNumber
     * Meta information extracted from the WSDL
     * - documentation: The flight number of the flight. This is required for use with scheduled airline messages but may be omitted for requests by tour operators. | Identifies a flight number (1 to 4 numbers followed by optional uppercase A - Z, which
     * specifies an operational suffix) or OPEN or ARNK.
     * - base: xs:string
     * - pattern: [0-9]{1,4}[A-Z]?
     * - use: optional
     * @var string
     */
    public $FlightNumber;
    /**
     * The TourOperatorFlightID
     * Meta information extracted from the WSDL
     * - documentation: ID of a flight in the Tour Operator's inventory. This flight is not necessarily in the inventory of an airline. Rather, it is a code created by tour operators. | Used for Character Strings, length 1 to 8
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $TourOperatorFlightID;
    /**
     * The ResBookDesigCode
     * Meta information extracted from the WSDL
     * - documentation: Specific Booking Class for this segment. | Used for an Alpha String, length 2 (for letter codes)
     * - base: xs:string
     * - pattern: [A-Z\s]{1,2}
     * - use: optional
     * @var string
     */
    public $ResBookDesigCode;
    /**
     * The ActionCode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ActionCode;
    /**
     * The NumberInParty
     * Meta information extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $NumberInParty;
    /**
     * The ElapsedTime
     * Meta information extracted from the WSDL
     * - documentation: Elapsed segment trip time.
     * @var int
     */
    public $ElapsedTime;
    /**
     * Constructor method for BookFlightSegmentType
     * @uses BookFlightSegmentType::setDepartureDateTime()
     * @uses BookFlightSegmentType::setDepartureAirport()
     * @uses BookFlightSegmentType::setArrivalAirport()
     * @uses BookFlightSegmentType::setOperatingAirline()
     * @uses BookFlightSegmentType::setEquipment()
     * @uses BookFlightSegmentType::setMarketingAirline()
     * @uses BookFlightSegmentType::setDisclosureAirline()
     * @uses BookFlightSegmentType::setMarriageGrp()
     * @uses BookFlightSegmentType::setStopAirports()
     * @uses BookFlightSegmentType::setDepartureTimeZone()
     * @uses BookFlightSegmentType::setArrivalTimeZone()
     * @uses BookFlightSegmentType::setOnTimePerformance()
     * @uses BookFlightSegmentType::setTPA_Extensions()
     * @uses BookFlightSegmentType::setArrivalDateTime()
     * @uses BookFlightSegmentType::setStopQuantity()
     * @uses BookFlightSegmentType::setRPH()
     * @uses BookFlightSegmentType::setInfoSource()
     * @uses BookFlightSegmentType::setFlightNumber()
     * @uses BookFlightSegmentType::setTourOperatorFlightID()
     * @uses BookFlightSegmentType::setResBookDesigCode()
     * @uses BookFlightSegmentType::setActionCode()
     * @uses BookFlightSegmentType::setNumberInParty()
     * @uses BookFlightSegmentType::setElapsedTime()
     * @param string $departureDateTime
     * @param \SabreSoap\StructType\AirportInformationType $departureAirport
     * @param \SabreSoap\StructType\AirportInformationType $arrivalAirport
     * @param \SabreSoap\StructType\OperatingAirlineType $operatingAirline
     * @param \SabreSoap\StructType\EquipmentType[] $equipment
     * @param \SabreSoap\StructType\CompanyNameType $marketingAirline
     * @param \SabreSoap\StructType\CompanyNameType $disclosureAirline
     * @param string $marriageGrp
     * @param \SabreSoap\StructType\StopAirports $stopAirports
     * @param \SabreSoap\StructType\DepartureTimeZone $departureTimeZone
     * @param \SabreSoap\StructType\ArrivalTimeZone $arrivalTimeZone
     * @param \SabreSoap\StructType\OnTimePerformance $onTimePerformance
     * @param \SabreSoap\StructType\TPA_Extensions $tPA_Extensions
     * @param string $arrivalDateTime
     * @param int $stopQuantity
     * @param string $rPH
     * @param string $infoSource
     * @param string $flightNumber
     * @param string $tourOperatorFlightID
     * @param string $resBookDesigCode
     * @param string $actionCode
     * @param int $numberInParty
     * @param int $elapsedTime
     */
    public function __construct($departureDateTime = null, \SabreSoap\StructType\AirportInformationType $departureAirport = null, \SabreSoap\StructType\AirportInformationType $arrivalAirport = null, \SabreSoap\StructType\OperatingAirlineType $operatingAirline = null, array $equipment = array(), \SabreSoap\StructType\CompanyNameType $marketingAirline = null, \SabreSoap\StructType\CompanyNameType $disclosureAirline = null, $marriageGrp = null, \SabreSoap\StructType\StopAirports $stopAirports = null, \SabreSoap\StructType\DepartureTimeZone $departureTimeZone = null, \SabreSoap\StructType\ArrivalTimeZone $arrivalTimeZone = null, \SabreSoap\StructType\OnTimePerformance $onTimePerformance = null, \SabreSoap\StructType\TPA_Extensions $tPA_Extensions = null, $arrivalDateTime = null, $stopQuantity = null, $rPH = null, $infoSource = null, $flightNumber = null, $tourOperatorFlightID = null, $resBookDesigCode = null, $actionCode = null, $numberInParty = null, $elapsedTime = null)
    {
        $this
            ->setDepartureDateTime($departureDateTime)
            ->setDepartureAirport($departureAirport)
            ->setArrivalAirport($arrivalAirport)
            ->setOperatingAirline($operatingAirline)
            ->setEquipment($equipment)
            ->setMarketingAirline($marketingAirline)
            ->setDisclosureAirline($disclosureAirline)
            ->setMarriageGrp($marriageGrp)
            ->setStopAirports($stopAirports)
            ->setDepartureTimeZone($departureTimeZone)
            ->setArrivalTimeZone($arrivalTimeZone)
            ->setOnTimePerformance($onTimePerformance)
            ->setTPA_Extensions($tPA_Extensions)
            ->setArrivalDateTime($arrivalDateTime)
            ->setStopQuantity($stopQuantity)
            ->setRPH($rPH)
            ->setInfoSource($infoSource)
            ->setFlightNumber($flightNumber)
            ->setTourOperatorFlightID($tourOperatorFlightID)
            ->setResBookDesigCode($resBookDesigCode)
            ->setActionCode($actionCode)
            ->setNumberInParty($numberInParty)
            ->setElapsedTime($elapsedTime);
    }
    /**
     * Get DepartureDateTime value
     * @return string
     */
    public function getDepartureDateTime()
    {
        return $this->DepartureDateTime;
    }
    /**
     * Set DepartureDateTime value
     * @param string $departureDateTime
     * @return \SabreSoap\StructType\BookFlightSegmentType
     */
    public function setDepartureDateTime($departureDateTime = null)
    {
        $this->DepartureDateTime = $departureDateTime;
        return $this;
    }
    /**
     * Get DepartureAirport value
     * @return \SabreSoap\StructType\AirportInformationType|null
     */
    public function getDepartureAirport()
    {
        return $this->DepartureAirport;
    }
    /**
     * Set DepartureAirport value
     * @param \SabreSoap\StructType\AirportInformationType $departureAirport
     * @return \SabreSoap\StructType\BookFlightSegmentType
     */
    public function setDepartureAirport(\SabreSoap\StructType\AirportInformationType $departureAirport = null)
    {
        $this->DepartureAirport = $departureAirport;
        return $this;
    }
    /**
     * Get ArrivalAirport value
     * @return \SabreSoap\StructType\AirportInformationType|null
     */
    public function getArrivalAirport()
    {
        return $this->ArrivalAirport;
    }
    /**
     * Set ArrivalAirport value
     * @param \SabreSoap\StructType\AirportInformationType $arrivalAirport
     * @return \SabreSoap\StructType\BookFlightSegmentType
     */
    public function setArrivalAirport(\SabreSoap\StructType\AirportInformationType $arrivalAirport = null)
    {
        $this->ArrivalAirport = $arrivalAirport;
        return $this;
    }
    /**
     * Get OperatingAirline value
     * @return \SabreSoap\StructType\OperatingAirlineType|null
     */
    public function getOperatingAirline()
    {
        return $this->OperatingAirline;
    }
    /**
     * Set OperatingAirline value
     * @param \SabreSoap\StructType\OperatingAirlineType $operatingAirline
     * @return \SabreSoap\StructType\BookFlightSegmentType
     */
    public function setOperatingAirline(\SabreSoap\StructType\OperatingAirlineType $operatingAirline = null)
    {
        $this->OperatingAirline = $operatingAirline;
        return $this;
    }
    /**
     * Get Equipment value
     * @return \SabreSoap\StructType\EquipmentType[]|null
     */
    public function getEquipment()
    {
        return $this->Equipment;
    }
    /**
     * Set Equipment value
     * @param \SabreSoap\StructType\EquipmentType[] $equipment
     * @return \SabreSoap\StructType\BookFlightSegmentType
     */
    public function setEquipment(array $equipment = array())
    {
        $this->Equipment = $equipment;
        return $this;
    }
    /**
     * Add item to Equipment value
     * @throws \InvalidArgumentException
     * @param \SabreSoap\StructType\EquipmentType $item
     * @return \SabreSoap\StructType\BookFlightSegmentType
     */
    public function addToEquipment(\SabreSoap\StructType\EquipmentType $item)
    {
        $this->Equipment[] = $item;
        return $this;
    }
    /**
     * Get MarketingAirline value
     * @return \SabreSoap\StructType\CompanyNameType|null
     */
    public function getMarketingAirline()
    {
        return $this->MarketingAirline;
    }
    /**
     * Set MarketingAirline value
     * @param \SabreSoap\StructType\CompanyNameType $marketingAirline
     * @return \SabreSoap\StructType\BookFlightSegmentType
     */
    public function setMarketingAirline(\SabreSoap\StructType\CompanyNameType $marketingAirline = null)
    {
        $this->MarketingAirline = $marketingAirline;
        return $this;
    }
    /**
     * Get DisclosureAirline value
     * @return \SabreSoap\StructType\CompanyNameType|null
     */
    public function getDisclosureAirline()
    {
        return $this->DisclosureAirline;
    }
    /**
     * Set DisclosureAirline value
     * @param \SabreSoap\StructType\CompanyNameType $disclosureAirline
     * @return \SabreSoap\StructType\BookFlightSegmentType
     */
    public function setDisclosureAirline(\SabreSoap\StructType\CompanyNameType $disclosureAirline = null)
    {
        $this->DisclosureAirline = $disclosureAirline;
        return $this;
    }
    /**
     * Get MarriageGrp value
     * @return string|null
     */
    public function getMarriageGrp()
    {
        return $this->MarriageGrp;
    }
    /**
     * Set MarriageGrp value
     * @param string $marriageGrp
     * @return \SabreSoap\StructType\BookFlightSegmentType
     */
    public function setMarriageGrp($marriageGrp = null)
    {
        $this->MarriageGrp = $marriageGrp;
        return $this;
    }
    /**
     * Get StopAirports value
     * @return \SabreSoap\StructType\StopAirports|null
     */
    public function getStopAirports()
    {
        return $this->StopAirports;
    }
    /**
     * Set StopAirports value
     * @param \SabreSoap\StructType\StopAirports $stopAirports
     * @return \SabreSoap\StructType\BookFlightSegmentType
     */
    public function setStopAirports(\SabreSoap\StructType\StopAirports $stopAirports = null)
    {
        $this->StopAirports = $stopAirports;
        return $this;
    }
    /**
     * Get DepartureTimeZone value
     * @return \SabreSoap\StructType\DepartureTimeZone|null
     */
    public function getDepartureTimeZone()
    {
        return $this->DepartureTimeZone;
    }
    /**
     * Set DepartureTimeZone value
     * @param \SabreSoap\StructType\DepartureTimeZone $departureTimeZone
     * @return \SabreSoap\StructType\BookFlightSegmentType
     */
    public function setDepartureTimeZone(\SabreSoap\StructType\DepartureTimeZone $departureTimeZone = null)
    {
        $this->DepartureTimeZone = $departureTimeZone;
        return $this;
    }
    /**
     * Get ArrivalTimeZone value
     * @return \SabreSoap\StructType\ArrivalTimeZone|null
     */
    public function getArrivalTimeZone()
    {
        return $this->ArrivalTimeZone;
    }
    /**
     * Set ArrivalTimeZone value
     * @param \SabreSoap\StructType\ArrivalTimeZone $arrivalTimeZone
     * @return \SabreSoap\StructType\BookFlightSegmentType
     */
    public function setArrivalTimeZone(\SabreSoap\StructType\ArrivalTimeZone $arrivalTimeZone = null)
    {
        $this->ArrivalTimeZone = $arrivalTimeZone;
        return $this;
    }
    /**
     * Get OnTimePerformance value
     * @return \SabreSoap\StructType\OnTimePerformance|null
     */
    public function getOnTimePerformance()
    {
        return $this->OnTimePerformance;
    }
    /**
     * Set OnTimePerformance value
     * @param \SabreSoap\StructType\OnTimePerformance $onTimePerformance
     * @return \SabreSoap\StructType\BookFlightSegmentType
     */
    public function setOnTimePerformance(\SabreSoap\StructType\OnTimePerformance $onTimePerformance = null)
    {
        $this->OnTimePerformance = $onTimePerformance;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \SabreSoap\StructType\TPA_Extensions|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \SabreSoap\StructType\TPA_Extensions $tPA_Extensions
     * @return \SabreSoap\StructType\BookFlightSegmentType
     */
    public function setTPA_Extensions(\SabreSoap\StructType\TPA_Extensions $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get ArrivalDateTime value
     * @return string|null
     */
    public function getArrivalDateTime()
    {
        return $this->ArrivalDateTime;
    }
    /**
     * Set ArrivalDateTime value
     * @param string $arrivalDateTime
     * @return \SabreSoap\StructType\BookFlightSegmentType
     */
    public function setArrivalDateTime($arrivalDateTime = null)
    {
        $this->ArrivalDateTime = $arrivalDateTime;
        return $this;
    }
    /**
     * Get StopQuantity value
     * @return int|null
     */
    public function getStopQuantity()
    {
        return $this->StopQuantity;
    }
    /**
     * Set StopQuantity value
     * @param int $stopQuantity
     * @return \SabreSoap\StructType\BookFlightSegmentType
     */
    public function setStopQuantity($stopQuantity = null)
    {
        $this->StopQuantity = $stopQuantity;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \SabreSoap\StructType\BookFlightSegmentType
     */
    public function setRPH($rPH = null)
    {
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get InfoSource value
     * @return string|null
     */
    public function getInfoSource()
    {
        return $this->InfoSource;
    }
    /**
     * Set InfoSource value
     * @param string $infoSource
     * @return \SabreSoap\StructType\BookFlightSegmentType
     */
    public function setInfoSource($infoSource = null)
    {
        $this->InfoSource = $infoSource;
        return $this;
    }
    /**
     * Get FlightNumber value
     * @return string|null
     */
    public function getFlightNumber()
    {
        return $this->FlightNumber;
    }
    /**
     * Set FlightNumber value
     * @param string $flightNumber
     * @return \SabreSoap\StructType\BookFlightSegmentType
     */
    public function setFlightNumber($flightNumber = null)
    {
        $this->FlightNumber = $flightNumber;
        return $this;
    }
    /**
     * Get TourOperatorFlightID value
     * @return string|null
     */
    public function getTourOperatorFlightID()
    {
        return $this->TourOperatorFlightID;
    }
    /**
     * Set TourOperatorFlightID value
     * @param string $tourOperatorFlightID
     * @return \SabreSoap\StructType\BookFlightSegmentType
     */
    public function setTourOperatorFlightID($tourOperatorFlightID = null)
    {
        $this->TourOperatorFlightID = $tourOperatorFlightID;
        return $this;
    }
    /**
     * Get ResBookDesigCode value
     * @return string|null
     */
    public function getResBookDesigCode()
    {
        return $this->ResBookDesigCode;
    }
    /**
     * Set ResBookDesigCode value
     * @param string $resBookDesigCode
     * @return \SabreSoap\StructType\BookFlightSegmentType
     */
    public function setResBookDesigCode($resBookDesigCode = null)
    {
        $this->ResBookDesigCode = $resBookDesigCode;
        return $this;
    }
    /**
     * Get ActionCode value
     * @return string|null
     */
    public function getActionCode()
    {
        return $this->ActionCode;
    }
    /**
     * Set ActionCode value
     * @param string $actionCode
     * @return \SabreSoap\StructType\BookFlightSegmentType
     */
    public function setActionCode($actionCode = null)
    {
        $this->ActionCode = $actionCode;
        return $this;
    }
    /**
     * Get NumberInParty value
     * @return int|null
     */
    public function getNumberInParty()
    {
        return $this->NumberInParty;
    }
    /**
     * Set NumberInParty value
     * @param int $numberInParty
     * @return \SabreSoap\StructType\BookFlightSegmentType
     */
    public function setNumberInParty($numberInParty = null)
    {
        $this->NumberInParty = $numberInParty;
        return $this;
    }
    /**
     * Get ElapsedTime value
     * @return int|null
     */
    public function getElapsedTime()
    {
        return $this->ElapsedTime;
    }
    /**
     * Set ElapsedTime value
     * @param int $elapsedTime
     * @return \SabreSoap\StructType\BookFlightSegmentType
     */
    public function setElapsedTime($elapsedTime = null)
    {
        $this->ElapsedTime = $elapsedTime;
        return $this;
    }
}
