<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AncillaryFeeGroup StructType
 * Meta information extracted from the WSDL
 * - documentation: Ancillary fee group returned | List of requested groups
 * @subpackage Structs
 */
class AncillaryFeeGroup extends AbstractStructBase
{
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Code;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Name;
    /**
     * The Count
     * @var string
     */
    public $Count;
    /**
     * The AncillaryFeeItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \SabreSoap\StructType\AncillaryFeeItem[]
     */
    public $AncillaryFeeItem;
    /**
     * The Message
     * @var string
     */
    public $Message;
    /**
     * Constructor method for AncillaryFeeGroup
     * @uses AncillaryFeeGroup::setCode()
     * @uses AncillaryFeeGroup::setName()
     * @uses AncillaryFeeGroup::setCount()
     * @uses AncillaryFeeGroup::setAncillaryFeeItem()
     * @uses AncillaryFeeGroup::setMessage()
     * @param string $code
     * @param string $name
     * @param string $count
     * @param \SabreSoap\StructType\AncillaryFeeItem[] $ancillaryFeeItem
     * @param string $message
     */
    public function __construct($code = null, $name = null, $count = null, array $ancillaryFeeItem = array(), $message = null)
    {
        $this
            ->setCode($code)
            ->setName($name)
            ->setCount($count)
            ->setAncillaryFeeItem($ancillaryFeeItem)
            ->setMessage($message);
    }
    /**
     * Get Code value
     * @return string
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \SabreSoap\StructType\AncillaryFeeGroup
     */
    public function setCode($code = null)
    {
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Name value
     * @return string
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \SabreSoap\StructType\AncillaryFeeGroup
     */
    public function setName($name = null)
    {
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Count value
     * @return string|null
     */
    public function getCount()
    {
        return $this->Count;
    }
    /**
     * Set Count value
     * @param string $count
     * @return \SabreSoap\StructType\AncillaryFeeGroup
     */
    public function setCount($count = null)
    {
        $this->Count = $count;
        return $this;
    }
    /**
     * Get AncillaryFeeItem value
     * @return \SabreSoap\StructType\AncillaryFeeItem[]|null
     */
    public function getAncillaryFeeItem()
    {
        return $this->AncillaryFeeItem;
    }
    /**
     * Set AncillaryFeeItem value
     * @param \SabreSoap\StructType\AncillaryFeeItem[] $ancillaryFeeItem
     * @return \SabreSoap\StructType\AncillaryFeeGroup
     */
    public function setAncillaryFeeItem(array $ancillaryFeeItem = array())
    {
        $this->AncillaryFeeItem = $ancillaryFeeItem;
        return $this;
    }
    /**
     * Add item to AncillaryFeeItem value
     * @throws \InvalidArgumentException
     * @param \SabreSoap\StructType\AncillaryFeeItem $item
     * @return \SabreSoap\StructType\AncillaryFeeGroup
     */
    public function addToAncillaryFeeItem(\SabreSoap\StructType\AncillaryFeeItem $item)
    {
        $this->AncillaryFeeItem[] = $item;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \SabreSoap\StructType\AncillaryFeeGroup
     */
    public function setMessage($message = null)
    {
        $this->Message = $message;
        return $this;
    }
}
