<?php

namespace SabreSoap\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for RequestType EnumType
 * Meta information extracted from the WSDL
 * - documentation: Used to specify if the request is an usual Exchange request (basic) or an Exchange Context Shopping request (context). When not specified, basic is assumed.
 * @subpackage Enumerations
 */
class RequestType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'basic'
     * @return string 'basic'
     */
    const VALUE_BASIC = 'basic';
    /**
     * Constant for value 'context'
     * @return string 'context'
     */
    const VALUE_CONTEXT = 'context';
    /**
     * Return allowed values
     * @uses self::VALUE_BASIC
     * @uses self::VALUE_CONTEXT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BASIC,
            self::VALUE_CONTEXT,
        );
    }
}
