<?php

namespace SabreSoap\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for PreferLevelType EnumType
 * Meta information extracted from the WSDL
 * - documentation: Used to specify a preference level for something that is or will be requested (e.g. a supplier of a service, a type of service, a form of payment, etc.).
 * @subpackage Enumerations
 */
class PreferLevelType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Only'
     * @return string 'Only'
     */
    const VALUE_ONLY = 'Only';
    /**
     * Constant for value 'Unacceptable'
     * @return string 'Unacceptable'
     */
    const VALUE_UNACCEPTABLE = 'Unacceptable';
    /**
     * Constant for value 'Preferred'
     * @return string 'Preferred'
     */
    const VALUE_PREFERRED = 'Preferred';
    /**
     * Return allowed values
     * @uses self::VALUE_ONLY
     * @uses self::VALUE_UNACCEPTABLE
     * @uses self::VALUE_PREFERRED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ONLY,
            self::VALUE_UNACCEPTABLE,
            self::VALUE_PREFERRED,
        );
    }
}
