<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ops StructType
 * Meta information extracted from the WSDL
 * - documentation: Populated if an Ops rule has been hit.
 * @subpackage Structs
 */
class Ops extends AbstractStructBase
{
    /**
     * The ActionCode
     * Meta information extracted from the WSDL
     * - documentation: Corresponds to data in the Ops rule (action target: Ops Action). The numeric id corresponds to an action performed by Travelocity.
     * - use: required
     * @var int
     */
    public $ActionCode;
    /**
     * The FareTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\FareTypes
     */
    public $FareTypes;
    /**
     * Constructor method for Ops
     * @uses Ops::setActionCode()
     * @uses Ops::setFareTypes()
     * @param int $actionCode
     * @param \SabreSoap\StructType\FareTypes $fareTypes
     */
    public function __construct($actionCode = null, \SabreSoap\StructType\FareTypes $fareTypes = null)
    {
        $this
            ->setActionCode($actionCode)
            ->setFareTypes($fareTypes);
    }
    /**
     * Get ActionCode value
     * @return int
     */
    public function getActionCode()
    {
        return $this->ActionCode;
    }
    /**
     * Set ActionCode value
     * @param int $actionCode
     * @return \SabreSoap\StructType\Ops
     */
    public function setActionCode($actionCode = null)
    {
        $this->ActionCode = $actionCode;
        return $this;
    }
    /**
     * Get FareTypes value
     * @return \SabreSoap\StructType\FareTypes|null
     */
    public function getFareTypes()
    {
        return $this->FareTypes;
    }
    /**
     * Set FareTypes value
     * @param \SabreSoap\StructType\FareTypes $fareTypes
     * @return \SabreSoap\StructType\Ops
     */
    public function setFareTypes(\SabreSoap\StructType\FareTypes $fareTypes = null)
    {
        $this->FareTypes = $fareTypes;
        return $this;
    }
}
