<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Manifest StructType
 * Meta information extracted from the WSDL
 * - type: ds:ManifestType
 * @subpackage Structs
 */
class Manifest extends AbstractStructBase
{
    /**
     * The Reference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: tns:Reference
     * @var \SabreSoap\StructType\Reference[]
     */
    public $Reference;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * The id
     * @var string
     */
    public $id;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - base: string
     * - minLength: 1
     * @var string
     */
    public $version;
    /**
     * Constructor method for Manifest
     * @uses Manifest::setReference()
     * @uses Manifest::setAny()
     * @uses Manifest::setId()
     * @uses Manifest::setVersion()
     * @param \SabreSoap\StructType\Reference[] $reference
     * @param \DOMDocument $any
     * @param string $id
     * @param string $version
     */
    public function __construct(array $reference = array(), \DOMDocument $any = null, $id = null, $version = null)
    {
        $this
            ->setReference($reference)
            ->setAny($any)
            ->setId($id)
            ->setVersion($version);
    }
    /**
     * Get Reference value
     * @return \SabreSoap\StructType\Reference[]|null
     */
    public function getReference()
    {
        return $this->Reference;
    }
    /**
     * Set Reference value
     * @param \SabreSoap\StructType\Reference[] $reference
     * @return \SabreSoap\StructType\Manifest
     */
    public function setReference(array $reference = array())
    {
        $this->Reference = $reference;
        return $this;
    }
    /**
     * Add item to Reference value
     * @throws \InvalidArgumentException
     * @param \SabreSoap\StructType\Reference $item
     * @return \SabreSoap\StructType\Manifest
     */
    public function addToReference(\SabreSoap\StructType\Reference $item)
    {
        $this->Reference[] = $item;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \SabreSoap\StructType\Manifest
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \SabreSoap\StructType\Manifest
     */
    public function setId($id = null)
    {
        $this->id = $id;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \SabreSoap\StructType\Manifest
     */
    public function setVersion($version = null)
    {
        $this->version = $version;
        return $this;
    }
}
