<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConnectionTime StructType
 * Meta information extracted from the WSDL
 * - documentation: Connection time between segments.
 * - minOccurs: 0
 * @subpackage Structs
 */
class ConnectionTime extends AbstractStructBase
{
    /**
     * The Min
     * Meta information extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $Min;
    /**
     * The Max
     * Meta information extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $Max;
    /**
     * The ExcludedConnectionBegin
     * Meta information extracted from the WSDL
     * - documentation: Excluded connection time begin in format HHMM | IntelliSell Time Window Boundary type in format HHMM.
     * - base: xs:string
     * - pattern: ([0-1][0-9]|2[0-3])[0-5][0-9]
     * - use: optional
     * @var string
     */
    public $ExcludedConnectionBegin;
    /**
     * The ExcludedConnectionEnd
     * Meta information extracted from the WSDL
     * - documentation: Excluded connection time end in format HHMM | IntelliSell Time Window Boundary type in format HHMM.
     * - base: xs:string
     * - pattern: ([0-1][0-9]|2[0-3])[0-5][0-9]
     * - use: optional
     * @var string
     */
    public $ExcludedConnectionEnd;
    /**
     * The EnableExcludedConnection
     * Meta information extracted from the WSDL
     * - documentation: Enable excluded connection time (default: true)
     * - use: optional
     * @var bool
     */
    public $EnableExcludedConnection;
    /**
     * Constructor method for ConnectionTime
     * @uses ConnectionTime::setMin()
     * @uses ConnectionTime::setMax()
     * @uses ConnectionTime::setExcludedConnectionBegin()
     * @uses ConnectionTime::setExcludedConnectionEnd()
     * @uses ConnectionTime::setEnableExcludedConnection()
     * @param int $min
     * @param int $max
     * @param string $excludedConnectionBegin
     * @param string $excludedConnectionEnd
     * @param bool $enableExcludedConnection
     */
    public function __construct($min = null, $max = null, $excludedConnectionBegin = null, $excludedConnectionEnd = null, $enableExcludedConnection = null)
    {
        $this
            ->setMin($min)
            ->setMax($max)
            ->setExcludedConnectionBegin($excludedConnectionBegin)
            ->setExcludedConnectionEnd($excludedConnectionEnd)
            ->setEnableExcludedConnection($enableExcludedConnection);
    }
    /**
     * Get Min value
     * @return int|null
     */
    public function getMin()
    {
        return $this->Min;
    }
    /**
     * Set Min value
     * @param int $min
     * @return \SabreSoap\StructType\ConnectionTime
     */
    public function setMin($min = null)
    {
        $this->Min = $min;
        return $this;
    }
    /**
     * Get Max value
     * @return int|null
     */
    public function getMax()
    {
        return $this->Max;
    }
    /**
     * Set Max value
     * @param int $max
     * @return \SabreSoap\StructType\ConnectionTime
     */
    public function setMax($max = null)
    {
        $this->Max = $max;
        return $this;
    }
    /**
     * Get ExcludedConnectionBegin value
     * @return string|null
     */
    public function getExcludedConnectionBegin()
    {
        return $this->ExcludedConnectionBegin;
    }
    /**
     * Set ExcludedConnectionBegin value
     * @param string $excludedConnectionBegin
     * @return \SabreSoap\StructType\ConnectionTime
     */
    public function setExcludedConnectionBegin($excludedConnectionBegin = null)
    {
        $this->ExcludedConnectionBegin = $excludedConnectionBegin;
        return $this;
    }
    /**
     * Get ExcludedConnectionEnd value
     * @return string|null
     */
    public function getExcludedConnectionEnd()
    {
        return $this->ExcludedConnectionEnd;
    }
    /**
     * Set ExcludedConnectionEnd value
     * @param string $excludedConnectionEnd
     * @return \SabreSoap\StructType\ConnectionTime
     */
    public function setExcludedConnectionEnd($excludedConnectionEnd = null)
    {
        $this->ExcludedConnectionEnd = $excludedConnectionEnd;
        return $this;
    }
    /**
     * Get EnableExcludedConnection value
     * @return bool|null
     */
    public function getEnableExcludedConnection()
    {
        return $this->EnableExcludedConnection;
    }
    /**
     * Set EnableExcludedConnection value
     * @param bool $enableExcludedConnection
     * @return \SabreSoap\StructType\ConnectionTime
     */
    public function setEnableExcludedConnection($enableExcludedConnection = null)
    {
        $this->EnableExcludedConnection = $enableExcludedConnection;
        return $this;
    }
}
